package io.adbrix.sdk.data.modelprovider;

import android.content.Context;

import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.IApiModel;
import io.adbrix.sdk.domain.model.InAppMessageModel;

public class InAppMessageModelProvider implements IApiModelProvider{
    private DataRegistry dataRegistry;
    private Context context;
    private DeviceRealtimeDataProvider deviceRealtimeDataProvider;

    public InAppMessageModelProvider(DataRegistry dataRegistry, Context context, DeviceRealtimeDataProvider deviceRealtimeDataProvider){
        this.dataRegistry = dataRegistry;
        this.context = context;
        this.deviceRealtimeDataProvider = deviceRealtimeDataProvider;
    }

    @Override
    public IApiModel provide() {
        return new InAppMessageModel(
                new CommonModelProvider(dataRegistry, context, deviceRealtimeDataProvider).provide(),
                dataRegistry.safeGetString(DataRegistryKey.STRING_IN_APP_MESSAGE_CHECKSUM, "")
        );
    }
}
