package io.adbrix.sdk.data.modelprovider;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.GDPRModel;
import io.adbrix.sdk.domain.model.IApiModel;
import io.adbrix.sdk.utils.CommonUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;

public class GDPRModelProvider implements IApiModelProvider{
    private DataRegistry dataRegistry;

    public GDPRModelProvider(DataRegistry dataRegistry){
        this.dataRegistry = dataRegistry;
    }

    @Override
    public IApiModel provide() {
        String appKey = dataRegistry.safeGetString(DataRegistryKey.STRING_APPKEY,null);
        String adid = dataRegistry.safeGetString(DataRegistryKey.STRING_ADID,null);

        SimpleDateFormat utc_df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        utc_df.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        String submitted_time = utc_df.format(new Date());

        JSONArray subject_identities = new JSONArray();
        JSONObject obj_subject_identities = new JSONObject();
        JSONObject extensions = new JSONObject();

        try {
            obj_subject_identities.put("identity_type", "android_advertising_id");
            obj_subject_identities.put("identity_value", CommonUtils.replaceWithJSONNull(adid));
            obj_subject_identities.put("identity_format", "raw");
            subject_identities.put(obj_subject_identities);

            JSONObject gdpr = new JSONObject();
            gdpr.put("appkey", appKey);
            gdpr.put("type", "remaster");
            extensions.put("gdpr.adbrix.io", gdpr);

        } catch (JSONException e){
            AbxLog.e(Arrays.toString(e.getStackTrace()), true);
        }

        return new GDPRModel(
                UUID.randomUUID().toString(),
                "erasure",
                submitted_time,
                subject_identities,
                "1.0",
                "",
                extensions
        );
    }
}
