package io.adbrix.sdk.data.modelprovider;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.domain.model.EventPackage;
import io.adbrix.sdk.domain.model.EventBundleModel;
import io.adbrix.sdk.domain.model.EventModel;
import io.adbrix.sdk.domain.model.IDataModel;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Arrays;
import java.util.Iterator;

public class EventBundleModelProvider implements IDataModelProvider {
    private IDataModel commonModel;
    private EventPackage eventPackage;

    public EventBundleModelProvider(IDataModel commonModel, EventPackage eventPackage){
        this.commonModel = commonModel;
        this.eventPackage = eventPackage;
    }

    @Override
    public IDataModel provide() {
        Iterator<EventModel> iterator = eventPackage.eventModels.iterator();
        JSONArray evts = new JSONArray();
        while (iterator.hasNext())
        {
            EventModel eventModel = iterator.next();
            try {
                evts.put(eventModel.getJson());
            } catch (JSONException e) {
                AbxLog.e(Arrays.toString(e.getStackTrace()), true);
            }
        }

        JSONObject common = null;
        try {
            common = commonModel.getJson();
        } catch (JSONException e) {
            AbxLog.e(Arrays.toString(e.getStackTrace()), true);
        }

        return new EventBundleModel(common, evts);
    }
}
