package io.adbrix.sdk.data.inAppMessage;

import android.view.MotionEvent;
import android.view.View;

public class SwipeListener implements View.OnTouchListener {
    private int previousFingerXPosition = 0;
    private int previousFingerYPosition = 0;
    private int downActionXPosition = 0;
    private int downActionYPosition = 0;
    private int viewPosition = 0;
    private int defaultViewWidth;

    private boolean isClosing = false;
    private boolean isScrollingUp = false;
    private boolean isScrollingDown = false;

    @Override
    public boolean onTouch(View view, MotionEvent event) {
        // Get finger position on screen
        final int X = (int) event.getRawX();
        final int Y = (int) event.getRawY();

        // Switch on motion event type
        switch (event.getAction() & MotionEvent.ACTION_MASK) {

            case MotionEvent.ACTION_DOWN:
                // save default base layout width
                defaultViewWidth = view.getWidth();

                // Init finger and view position
                previousFingerXPosition = X;
                previousFingerYPosition = Y;
                downActionXPosition = X;
                downActionYPosition = Y;

                viewPosition = (int) view.getX();
                break;

            case MotionEvent.ACTION_UP:
                // If user was doing a scroll up
                if(isScrollingUp){
                    // Reset view position
                    view.setX(0);
                    // We are not in scrolling up mode anymore
                    isScrollingUp = false;
                }

                // If user was doing a scroll down
                if(isScrollingDown){
                    // Reset view position
                    view.setX(0);
                    // Reset base layout size
                    view.getLayoutParams().width = defaultViewWidth;
                    view.requestLayout();
                    // We are not in scrolling down mode anymore
                    isScrollingDown = false;
                }

                if (Math.abs(downActionXPosition - X) <= 2 && Math.abs(downActionYPosition - Y) <= 2) {
                    onClick();
                }
                break;
            case MotionEvent.ACTION_MOVE:
                if(!isClosing){
                    int currentXPosition = (int) view.getX();

                    // If we scroll up
                    if(previousFingerXPosition > X){
                        // First time android rise an event for "up" move
                        if(!isScrollingUp){
                            isScrollingUp = true;
                        }

                        // Has user scroll down before -> view is smaller than it's default size -> resize it instead of change it position
                        if(view.getWidth() < defaultViewWidth){
                            view.getLayoutParams().width = view.getWidth() - (X - previousFingerXPosition);
                            view.requestLayout();
                        }
                        else {
                            // Has user scroll enough to "auto close" popup ?
                            if ((viewPosition - currentXPosition) > defaultViewWidth / 2) {
                                onSwipeLeft(event);
                                return true;
                            }else if(viewPosition - currentXPosition > defaultViewWidth / 10 && (event.getEventTime() - event.getDownTime()) < 100){
                                onSwipeLeft(event);
                                return true;
                            }
                        }
                        view.setX(view.getX() + (X - previousFingerXPosition));

                    }
                    // If we scroll down
                    else{
                        // First time android rise an event for "down" move
                        if(!isScrollingDown){
                            isScrollingDown = true;
                        }

                        // Has user scroll enough to "auto close" popup ?
                        if (Math.abs(viewPosition - currentXPosition) > defaultViewWidth / 2)
                        {
                            onSwipeRight(event);
                            return true;
                        }else if(Math.abs(viewPosition - currentXPosition) > defaultViewWidth / 10 && (event.getEventTime() - event.getDownTime()) < 100){
                            onSwipeRight(event);
                            return true;
                        }

                        // Change base layout size and position (must change position because view anchor is top left corner)
                        view.setX(view.getX() + (X - previousFingerXPosition));
                        //view.getLayoutParams().width = view.getWidth() - (X - previousFingerPosition);
                        view.requestLayout();
                    }

                    // Update position
                    previousFingerXPosition = X;
                }
                break;
        }
        return true;
    }

    public void onSwipeRight(MotionEvent motionEvent) {

    }

    public void onSwipeLeft(MotionEvent motionEvent) {

    }

    public void onClick() {

    }
}
