package io.adbrix.sdk.data.inAppMessage;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import io.adbrix.sdk.component.AbxLog;

public class InAppMessageSqliteStore extends SQLiteOpenHelper {
    public static final int DATABASE_VERSION = 1;
    public static final String DATABASE_NAME = "InAppMessage.db";

    InAppMessageTable inAppMessageTable;
    TriggersTable triggersTable;
    AvailableTimeTable availableTimeTable;
    CurrentFrequencyCapTable currentFrequencyCapTable;
    ImageTable imageTable;

    public InAppMessageSqliteStore(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        inAppMessageTable = new InAppMessageTable();
        triggersTable = new TriggersTable();
        availableTimeTable = new AvailableTimeTable();
        currentFrequencyCapTable = new CurrentFrequencyCapTable();
        imageTable = new ImageTable();
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(inAppMessageTable.getSqlCreateEntries());
        db.execSQL(triggersTable.getSqlCreateEntries());
        db.execSQL(availableTimeTable.getSqlCreateEntries());
        db.execSQL(currentFrequencyCapTable.getSqlCreateEntries());
        db.execSQL(imageTable.getSqlCreateEntries());

        AbxLog.d("InAppMessage Database onCreate", true);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        // This database is only a cache for online data, so its upgrade policy is
        // to simply to discard the data and start over
        db.execSQL(inAppMessageTable.getSqlDeleteEntries());
        db.execSQL(triggersTable.getSqlDeleteEntries());
        db.execSQL(availableTimeTable.getSqlDeleteEntries());
        db.execSQL(currentFrequencyCapTable.getSqlDeleteEntries());
        db.execSQL(imageTable.getSqlDeleteEntries());
        onCreate(db);

        AbxLog.d("InAppMessage Database onUpgrade", true);
    }

    public void deleteDB(){
        SQLiteDatabase db = this.getWritableDatabase();

        db.execSQL(inAppMessageTable.getSqlDeleteEntries());
        db.execSQL(triggersTable.getSqlDeleteEntries());
        db.execSQL(availableTimeTable.getSqlDeleteEntries());
        db.execSQL(currentFrequencyCapTable.getSqlDeleteEntries());
        db.execSQL(imageTable.getSqlDeleteEntries());

        AbxLog.d("InAppMessage Database is deleted", true);
    }

    public void restartDB(){
        SQLiteDatabase db = this.getWritableDatabase();

        db.execSQL(inAppMessageTable.getSqlCreateEntries());
        db.execSQL(triggersTable.getSqlCreateEntries());
        db.execSQL(availableTimeTable.getSqlCreateEntries());
        db.execSQL(currentFrequencyCapTable.getSqlCreateEntries());
        db.execSQL(imageTable.getSqlCreateEntries());

        AbxLog.d("InAppMessage Database is created", true);
    }

    interface Table{
        public String getSqlCreateEntries();
        public String getSqlDeleteEntries();
    }

    public static class InAppMessageTable implements Table {
        public static final String TABLE_NAME = "InAppMessage";
        public static final String COLUMN_NAME_CAMPAIGN_ID = "CampaignId";
        public static final String COLUMN_NAME_PORTRAIT_AVAILABLE = "PortraitAvailable";
        public static final String COLUMN_NAME_LANDSCAPE_AVAILABLE = "LandscapeAvailable";
        public static final String COLUMN_NAME_EXTERNAL_ATTR = "ExternalAttr";
        public static final String COLUMN_NAME_TIMEZONE_OFFSET = "TimezoneOffset";
        public static final String COLUMN_NAME_TIMEZONE_TYPE = "TimezoneType";
        public static final String COLUMN_NAME_TYPE = "Type";
        public static final String COLUMN_NAME_LAYOUT = "Layout";
        public static final String COLUMN_NAME_HTML = "html";
        public static final String COLUMN_NAME_BG_STYLE_BG_COLOR = "BgStyleBgColor";
        public static final String COLUMN_NAME_BG_STYLE_OVERLAY_COLOR = "BgStyleOverlayColor";
        public static final String COLUMN_NAME_CONTENTS_TEXT = "ContentsText";
        public static final String COLUMN_NAME_CONTENTS_BUTTONS = "ContentsButtons";
        public static final String COLUMN_NAME_DEFAULT_CLOSE_BUTTON_COLOR = "DefaultCloseButtonColor";
        public static final String COLUMN_NAME_DEFAULT_CLOSE_BUTTON_BG_COLOR = "DefaultCloseButtonBgColor";
        public static final String COLUMN_NAME_STICKY_BANNER_OPTION = "StickyBannerOption";
        public static final String COLUMN_NAME_FREQUENCY_CAP_PER_SESSION = "FrequencyCapPerSession";
        public static final String COLUMN_NAME_FREQUENCY_CAP_PER_USER = "FrequencyCapPerUser";
        public static final String COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_IN_MINUTES = "FrequencyCapForPeriodInMinutes";
        public static final String COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_PER_PERIOD = "FrequencyCapForPeriodPerPeriod";
        public static final String COLUMN_NAME_START_DATETIME = "StartDateTime";
        public static final String COLUMN_NAME_END_DATETIME = "EndDateTime";
        public static final String COLUMN_NAME_LAST_UPDATED_DATETIME = "LastUpdatedTime";
        public static final String COLUMN_NAME_UNAVAILABLE_DAY = "UnavailableDay";
        public static final String COLUMN_NAME_UNAVAILABLE_TIME = "UnavailableTime";

        @Override
        public String getSqlCreateEntries() {

            return "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " (" +
                    COLUMN_NAME_CAMPAIGN_ID + " TEXT UNIQUE," +
                    COLUMN_NAME_PORTRAIT_AVAILABLE + " INT," +
                    COLUMN_NAME_LANDSCAPE_AVAILABLE + " INT," +
                    COLUMN_NAME_EXTERNAL_ATTR + " TEXT," +
                    COLUMN_NAME_TIMEZONE_OFFSET + " INT," +
                    COLUMN_NAME_TIMEZONE_TYPE + " TEXT," +
                    COLUMN_NAME_TYPE + " TEXT," +
                    COLUMN_NAME_LAYOUT + " TEXT," +
                    COLUMN_NAME_HTML + " TEXT," +
                    COLUMN_NAME_BG_STYLE_BG_COLOR + " TEXT," +
                    COLUMN_NAME_BG_STYLE_OVERLAY_COLOR + " TEXT," +
                    COLUMN_NAME_CONTENTS_TEXT + " TEXT," +
                    COLUMN_NAME_CONTENTS_BUTTONS + " TEXT," +
                    COLUMN_NAME_DEFAULT_CLOSE_BUTTON_COLOR + " TEXT," +
                    COLUMN_NAME_DEFAULT_CLOSE_BUTTON_BG_COLOR + " TEXT," +
                    COLUMN_NAME_STICKY_BANNER_OPTION + " TEXT," +
                    COLUMN_NAME_FREQUENCY_CAP_PER_SESSION + " INT," +
                    COLUMN_NAME_FREQUENCY_CAP_PER_USER + " INT," +
                    COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_IN_MINUTES + " INT," +
                    COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_PER_PERIOD + " INT," +
                    COLUMN_NAME_START_DATETIME + " INT," +
                    COLUMN_NAME_END_DATETIME + " INT," +
                    COLUMN_NAME_LAST_UPDATED_DATETIME + " INT," +
                    COLUMN_NAME_UNAVAILABLE_DAY + " TEXT," +
                    COLUMN_NAME_UNAVAILABLE_TIME + " INT)";
        }

        @Override
        public String getSqlDeleteEntries() {
            return "DROP TABLE IF EXISTS " + TABLE_NAME;
        }
    }

    public static class TriggersTable implements Table {
        public static final String TABLE_NAME = "Triggers";
        public static final String COLUMN_NAME_CAMPAIGN_ID = "CampaignId";
        public static final String COLUMN_NAME_TYPE = "Type";
        public static final String COLUMN_NAME_EVENT_NAME = "EventName";
        public static final String COLUMN_NAME_PRIORITY = "Priority";

        @Override
        public String getSqlCreateEntries() {

            return "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " (" +
                    COLUMN_NAME_CAMPAIGN_ID + " TEXT," +
                    COLUMN_NAME_TYPE + " TEXT," +
                    COLUMN_NAME_EVENT_NAME + " TEXT, " +
                    COLUMN_NAME_PRIORITY + " INT)";
        }

        @Override
        public String getSqlDeleteEntries() {

            return "DROP TABLE IF EXISTS " + TABLE_NAME;
        }
    }

    public static class AvailableTimeTable implements Table {
        public static final String TABLE_NAME = "AvailableTime";
        public static final String COLUMN_NAME_CAMPAIGN_ID = "CampaignId";
        public static final String COLUMN_NAME_DAY = "Day";
        public static final String COLUMN_NAME_START_MIN = "StartMin";
        public static final String COLUMN_NAME_END_MIN = "EndMin";

        @Override
        public String getSqlCreateEntries() {

            return "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " (" +
                    COLUMN_NAME_CAMPAIGN_ID + " TEXT," +
                    COLUMN_NAME_DAY + " TEXT," +
                    COLUMN_NAME_START_MIN + " INT," +
                    COLUMN_NAME_END_MIN + " INT)";
        }

        @Override
        public String getSqlDeleteEntries() {

            return "DROP TABLE IF EXISTS " + TABLE_NAME;
        }
    }

    public static class CurrentFrequencyCapTable implements Table {
        public static final String TABLE_NAME = "CurrentFrequency";
        public static final String COLUMN_NAME_CAMPAIGN_ID = "CampaignId";
        public static final String COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_SESSION = "CurrentFrequencyCapPerSession";
        public static final String COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_USER = "CurrentFrequencyCapPerUser";
        public static final String COLUMN_NAME_FREQUENCY_LAST_GROUP_START_TIME = "FrequencyLastGroupStartTime";
        public static final String COLUMN_NAME_FREQUENCY_LAST_GROUP_COUNT = "FrequencyLastGroupCount";

        @Override
        public String getSqlCreateEntries() {

            return "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " (" +
                    COLUMN_NAME_CAMPAIGN_ID + " TEXT UNIQUE," +
                    COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_SESSION + " INT," +
                    COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_USER + " INT, " +
                    COLUMN_NAME_FREQUENCY_LAST_GROUP_START_TIME + " INT, " +
                    COLUMN_NAME_FREQUENCY_LAST_GROUP_COUNT + " INT)";
        }

        @Override
        public String getSqlDeleteEntries() {

            return "DROP TABLE IF EXISTS " + TABLE_NAME;
        }
    }

    public static class ImageTable implements Table {
        public static final String TABLE_NAME = "Image";
        public static final String COLUMN_NAME_CAMPAIGN_ID = "CampaignId";
        public static final String COLUMN_NAME_ORIENTATION = "Orientation";
        public static final String COLUMN_NAME_URL = "Url";
        public static final String COLUMN_NAME_IMAGE_PATH_STRING = "ImagePathString";
        public static final String COLUMN_NAME_CLICK_ACTION = "ClickAction";
        public static final String COLUMN_NAME_IS_FIRST_SHOW = "IsFirstShow";

        @Override
        public String getSqlCreateEntries() {

            return "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " (" +
                    COLUMN_NAME_CAMPAIGN_ID + " TEXT," +
                    COLUMN_NAME_ORIENTATION + " TEXT," +
                    COLUMN_NAME_URL + " TEXT," +
                    COLUMN_NAME_IMAGE_PATH_STRING + " TEXT," +
                    COLUMN_NAME_CLICK_ACTION + " TEXT," +
                    COLUMN_NAME_IS_FIRST_SHOW + " INT)";
        }

        @Override
        public String getSqlDeleteEntries() {

            return "DROP TABLE IF EXISTS " + TABLE_NAME;
        }
    }
}
