package io.adbrix.sdk.data.inAppMessage;

import io.adbrix.sdk.component.AbxLog;

public class InAppMessageFactoryContainer {
    private final FullScreenMessageViewFactory fullScreenMessageViewFactory;
    private final ModalMessageViewFactory modalMessageViewFactory;
    private final SlideUpMessageViewFactory slideUpMessageViewFactory;

    private final String FULL_SCREEN = "full_screen";
    private final String MODAL = "modal";
    private final String STICKY_BANNER = "sticky_banner";

    public InAppMessageFactoryContainer(InAppMessageDAO inAppMessageDAO){
        fullScreenMessageViewFactory = new FullScreenMessageViewFactory(inAppMessageDAO);
        modalMessageViewFactory = new ModalMessageViewFactory(inAppMessageDAO);
        slideUpMessageViewFactory = new SlideUpMessageViewFactory(inAppMessageDAO);
    }

    public IInAppMessageViewFactory getInAppMessageViewFactory(InAppMessage inAppMessage) {
        switch (inAppMessage.getType()) {
            case FULL_SCREEN:
                return fullScreenMessageViewFactory;
            case MODAL:
                return modalMessageViewFactory;
            case STICKY_BANNER :
                return slideUpMessageViewFactory;
            default:
                AbxLog.w("Invalid in app message type. Cannot get factory.", true);
                return null;
        }
    }
}
