package io.adbrix.sdk.data.inAppMessage;

import android.app.Activity;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.view.View;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.IObservable;
import io.adbrix.sdk.component.IObserver;
import io.adbrix.sdk.component.InAppMessageClickPostingObservable;
import io.adbrix.sdk.data.ABXBooleanState;
import io.adbrix.sdk.domain.model.LogEventParameter;

public interface IInAppMessageViewFactory extends IObservable<LogEventParameter> {
    void createInAppMessage(Activity activity, InAppMessage inAppMessage, IObserver<AbxDialog> abxDialogIObserver);

    class InAppMessageOnClickListener implements View.OnClickListener {

        String campaignId;
        String actionId;
        String actionType;
        String actionArg;
        Dialog dialog;
        Runnable callback;
        InAppMessageDAO inAppMessageDAO;

        public InAppMessageOnClickListener(
                String campaignId,
                String actionId,
                String actionType,
                String actionArg,
                Dialog dialog,
                Runnable callback,
                InAppMessageDAO inAppMessageDAO
        ){
            this.actionId = actionId;
            this.actionType = actionType;
            this.actionArg = actionArg;
            this.dialog = dialog;
            this.callback = callback;
            this.inAppMessageDAO = inAppMessageDAO;
            this.campaignId = campaignId;
        }

        @Override
        public void onClick(View v) {
            try {
                if (ActionType.CLOSE.getValue().equals(actionType)) {
                    if (dialog != null) {
                        dialog.dismiss();
                    }

                    ABXBooleanState.getInstance().isInAppMessagePresented.getAndSet(false);
                } else if (ActionType.WEBLINK.getValue().equals(actionType)) {
                    Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(actionArg));
                    try {
                        v.getContext().startActivity(intent);
                    } catch (ActivityNotFoundException exception) {
                        AbxLog.d("ModalMessageViewFactory: ActivityNotFoundException, button action url was " + actionArg, true);
                    }
                } else if (ActionType.DEEPLINK_AND_CLOSE.getValue().equals(actionType) || ActionType.WEBLINK_AND_CLOSE.getValue().equals(actionType)) {
                    Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(actionArg));
                    if (dialog != null) {
                        dialog.dismiss();
                    }

                    try {
                        v.getContext().startActivity(intent);
                    } catch (ActivityNotFoundException exception) {
                        AbxLog.d("ModalMessageViewFactory: ActivityNotFoundException, button action url was " + actionArg, true);
                    }

                    ABXBooleanState.getInstance().isInAppMessagePresented.getAndSet(false);
                } else if (ActionType.DONT_SHOW_ME_TODAY_AND_CLOSE.getValue().equals(actionType)) {
                    SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat("EE", Locale.ENGLISH);

                    long currentTimeMillis = System.currentTimeMillis() + TimeZone.getDefault().getRawOffset();
                    String currentDay = localSimpleDateFormat.format(System.currentTimeMillis());

                    inAppMessageDAO.updateOneDayCloseInAppMessageTable(campaignId, currentDay, currentTimeMillis);

                    if (dialog != null) {
                        dialog.dismiss();
                    }

                    ABXBooleanState.getInstance().isInAppMessagePresented.getAndSet(false);
                } else {
                    AbxLog.d("messageViewFactory: unknown button action '" + actionType + "'", true);
                }

                if (callback != null)
                    callback.run();

                InAppMessageClickPostingObservable.getInstance().postInAppMessageClickToMainThread(
                        actionId,
                        actionType,
                        actionArg,
                        ActionType.CLOSE.getValue().equals(actionType)
                                || ActionType.DEEPLINK_AND_CLOSE.getValue().equals(actionType)
                                || ActionType.WEBLINK_AND_CLOSE.getValue().equals(actionType)
                                || ActionType.DONT_SHOW_ME_TODAY_AND_CLOSE.getValue().equals(actionType)
                );
            }catch (NullPointerException nullPointerException){
                AbxLog.d("NullPointerException in inAppMessage click action : " + nullPointerException.toString(),true);
            }
        }
    }

    enum LayoutType {
        IMAGE("image"),
        IMAGE_AND_TEXT("image_and_text"),
        TEXT("text");
//        HTML("html")

        final private String value;

        LayoutType(String value) {
            this.value = value;
        }


        public String getValue(){
            return value;
        }
    }

    enum ActionType {
        CLOSE("close"),
        DEEPLINK_AND_CLOSE("deeplink_and_close"),
        WEBLINK("weblink"),
        WEBLINK_AND_CLOSE("weblink_and_close"),
        DONT_SHOW_ME_TODAY_AND_CLOSE("dont_show_me_today_and_close");

        final private String value;

        ActionType(String value) {
            this.value = value;
        }

        public String getValue(){
            return value;
        }
    }

    enum EventType {
        IMPRESSION("impression"),
        CLICK("click");

        final private String value;

        EventType(String value) {
            this.value = value;
        }

        public String getValue(){
            return value;
        }
    }

    enum TextAlign {
        CENTER("center"),
        RIGHT("right"),
        LEFT("left");

        final private String value;

        TextAlign(String value) {
            this.value = value;
        }

        public String getValue(){
            return value;
        }
    }

    enum imageInfoHashmapValue{
        IMAGE_BITMAP("imageBitmap"),
        IMAGE_URL("imageURL"),
        IS_DOWNLOADED("isDownLoaded"),
        CLICK_ACTION("clickAction");

        final private String value;

        imageInfoHashmapValue(String value) {
            this.value = value;
        }

        public String getValue(){
            return value;
        }
    }
}
