package io.adbrix.sdk.data.dataprovider;

import java.util.List;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.repository.DataRegistry;

public abstract class AbstractDataProvider {
    private DataRegistry dataRegistry;
    public AbstractDataProvider(DataRegistry dataRegistry) {
        this.dataRegistry = dataRegistry;
    }

    public abstract void provideDefaultValues();
    public abstract void asyncProvide(IDataProviderResultListener dataProviderResultListener);
    public abstract void refreshData();

    //region Data 입력 헬퍼 메소드
    protected void provideData(DataUnit data) {
        this.dataRegistry.putDataRegistry(data);
    }

    protected void provideData(List<DataUnit> data) {
        this.dataRegistry.putDataRegistry(data);
    }

    protected int safeGetInt(DataRegistryKey key, int defaultValue)
    {
        return this.dataRegistry.safeGetInt(key,defaultValue);
    }

    protected boolean safeGetBoolean(DataRegistryKey key, boolean defaultValue)
    {
        return this.dataRegistry.safeGetBoolean(key,defaultValue);
    }

    protected String safeGetString(DataRegistryKey key, String defaultValue)
    {
        return this.dataRegistry.safeGetString(key,defaultValue);
    }

    protected Boolean getBoolean(DataRegistryKey key)
    {
        try {
            return this.dataRegistry.getBoolean(key);
        } catch (DataUnit.DataUnitInvalidTypeCastingException e) {
            AbxLog.e( "Invalid type casting of dataRegistryKey " + key.name(), true);
            return null;
        } catch (DataRegistry.CanNotFindDataRegistryKeyException e) {
            AbxLog.e("Cannot find dataRegistryKey " + key.name(), true);
            return null;
        }
    }

    protected void putInt(DataRegistryKey key, Integer value, int priority, boolean isSaveToDisk) {
        this.dataRegistry.putDataRegistry(
            new DataUnit(
                key,
                value.toString(),
                priority,
                this.getClass().getName(),
                isSaveToDisk
            )
        );
    }

    protected void putString(DataRegistryKey key, String value, int priority, boolean isSaveToDisk) {
        this.dataRegistry.putDataRegistry(
            new DataUnit(
                key,
                value,
                priority,
                this.getClass().getName(),
                isSaveToDisk
            )
        );
    }

    protected void putBoolean(DataRegistryKey key, Boolean value, int priority, boolean isSaveToDisk) {
        this.dataRegistry.putDataRegistry(
            new DataUnit(
                key,
                value.toString(),
                priority,
                this.getClass().getName(),
                isSaveToDisk
            )
        );
    }

    protected void putFloat(DataRegistryKey key, Float value, int priority, boolean isSaveToDisk) {
        this.dataRegistry.putDataRegistry(
            new DataUnit(
                key,
                value.toString(),
                priority,
                this.getClass().getName(),
                isSaveToDisk
            )
        );
    }
}
