package io.adbrix.sdk.component;

import java.util.ArrayList;
import java.util.List;

public class OsPushEnableObservable implements IObservable<Boolean>{

    private OsPushEnableObservable(){}

    private static class Singleton{
        private static final OsPushEnableObservable instance = new OsPushEnableObservable();
    }

    private List<IObserver<Boolean>> observers = new ArrayList<>();

    public static OsPushEnableObservable getInstance(){
        return Singleton.instance;
    }

    @Override
    public void add(IObserver<Boolean> observer) {
        observers.add(observer);
    }

    @Override
    public void delete(IObserver<Boolean> observer) {
        observers.remove(observer);
    }

    @Override
    public void notifyObserver(Boolean object) {
        for (IObserver<Boolean> observer : observers){
            observer.update(object);
        }
    }
}
