package io.adbrix.sdk.component;

import android.content.Context;

import io.adbrix.sdk.component.autoEvent.DeeplinkAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.FirstOpenAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.SessionAutoEventGenerator;
import io.adbrix.sdk.configuration.IABXContext;
import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.dataprovider.DeviceStaticDataProvider;
import io.adbrix.sdk.data.dataprovider.V1DataProvider;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.data.repository.UserPropertyManager;
import io.adbrix.sdk.data.repository.datasource.IDataContext;

public interface IABXComponentsFactory {

    void setAndroidContext(Context context);
    void setABXContext(IABXContext context);

    ILogger createOrGetLogger();
    DataRegistry createOrGetDataRegistry() throws ComponentsCanNotCreateException;
    IDataContext createOrGetDataContext() throws ComponentsCanNotCreateException;
    DeviceRealtimeDataProvider createOrGetDeviceRealtimeDataProvider() throws ComponentsCanNotCreateException;
    DeviceStaticDataProvider createOrGetDeviceStaticDataProvider() throws ComponentsCanNotCreateException;
    V1DataProvider createOrGetV1DataProvider() throws ComponentsCanNotCreateException;
    Context getAndroidContext() throws ComponentsCanNotCreateException;
    UserPropertyManager createOrGetUserPropertyManager() throws ComponentsCanNotCreateException;
    IEventSender createOrGetEventSender() throws ComponentsCanNotCreateException;
    IABXContext getABXContext() throws ComponentsCanNotCreateException;

    FirstOpenAutoEventGenerator createOrGetFirstOpenAutoEventGenerator() throws ComponentsCanNotCreateException;
    DeeplinkAutoEventGenerator createOrGetDeeplinkAutoEventGenerator() throws ComponentsCanNotCreateException;

    class ComponentsCanNotCreateException extends Exception{
        public ComponentsCanNotCreateException(String message){ super(message);}
    }
}


