package io.adbrix.sdk.domain.model;

import java.util.LinkedList;
import java.util.Queue;

public class UserPropertyCommand {

    private Queue<UserPropertyCommandUnit> commands = new LinkedList<>();

    //region Package Level
    public Queue<UserPropertyCommandUnit> getCommands()
    {
        return commands;
    }
    public static enum UserPropertyCommandUnitType
    {
        SET,
        UNSET
    }

    public static class UserPropertyCommandUnit
    {
        // final 제거 이유는 '-' 를 '_'로 보정해야 하는 로직이 Manager에 있기 때문에 부득이하게 처리함 ;_;
        public UserPropertyCommandUnitType commandType;
        public String key;
        public Object value;

        UserPropertyCommandUnit(UserPropertyCommandUnitType commandType, String key,Object value) {
            this.commandType = commandType;
            this.key = key;
            this.value = value;
        }
    }
    //endregion


    public UserPropertyCommand set(String key, Object value)
    {
        commands.offer(
            new UserPropertyCommandUnit(
                UserPropertyCommandUnitType.SET,
                key,
                value
            )
        );
        return this;
    }

    public UserPropertyCommand unset(String key)
    {
        commands.offer(
            new UserPropertyCommandUnit(
                    UserPropertyCommandUnitType.UNSET,
                    key,
                    null
            )
        );
        return this;
    }

}
