package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.utils.CoreUtils;

public class IdentityModel implements IDataModel{
    public String adid;
    public String gaid;
    public String uuid;
    public String idfa;
    public String idfv;
    public String igaw_id;
    public boolean ad_id_opt_out;
    public String device_id;
    public String registration_id;
    public boolean is_push_enable;
    public boolean is_push_enable_os;

    public IdentityModel(
            String adid,
            String gaid,
            String uuid,
            String idfa,
            String idfv,
            String igaw_id,
            boolean ad_id_opt_out,
            String device_id,
            String registration_id,
            boolean is_push_enable,
            boolean is_push_enable_os
    ) {
        if (adid == null){
            this.adid = "uuid:" + uuid;
        }
        else {
            this.adid = adid;
        }
        this.gaid = gaid;
        this.uuid = uuid;
        this.idfa = idfa;
        this.idfv = idfv;
        this.igaw_id = igaw_id;
        this.ad_id_opt_out = ad_id_opt_out;
        this.device_id = device_id;
        this.registration_id = registration_id;
        this.is_push_enable = is_push_enable;
        this.is_push_enable_os = is_push_enable_os;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject root = new JSONObject();
        {
            root.put("adid", this.adid);
            root.put("gaid", CoreUtils.convertNullableToJSONNullable(this.gaid));
            root.put("uuid", this.uuid);
            root.put("idfa", CoreUtils.convertNullableToJSONNullable(this.idfa));
            root.put("idfv", CoreUtils.convertNullableToJSONNullable(this.idfv));
            root.put("igaw_id", this.igaw_id);
            root.put("ad_id_opt_out", this.ad_id_opt_out);
            root.put("device_id", CoreUtils.convertNullableToJSONNullable(this.device_id));
            root.put("registration_id", CoreUtils.convertNullableToJSONNullable(this.registration_id));
            root.put("is_push_enable", this.is_push_enable);
            root.put("is_push_enable_os", this.is_push_enable_os);
        }
        return root;
    }
}
