package io.adbrix.sdk.data.dataprovider;

import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.entity.DataUnit;

import java.util.List;

public abstract class AbstractDataProvider {
    private DataRegistry dataRegistry;
    public AbstractDataProvider(DataRegistry dataRegistry) {
        this.dataRegistry = dataRegistry;
    }

    public abstract void provideDefaultValues();
    public abstract void asyncProvide(IDataProviderResultListener dataProviderResultListener);
    public abstract void refreshData();

    //region Data 입력 헬퍼 메소드
    protected void provideData(DataUnit data) {
        this.dataRegistry.putDataRegistry(data);
    }

    protected void provideData(List<DataUnit> data) {
        this.dataRegistry.putDataRegistry(data);
    }

    protected int safeGetInt(DataRegistryKey key, int defaultValue)
    {
        return this.dataRegistry.safeGetInt(key,defaultValue);
    }

    protected boolean safeGetBoolean(DataRegistryKey key, boolean defaultValue)
    {
        return this.dataRegistry.safeGetBoolean(key,defaultValue);
    }

    protected String safeGetString(DataRegistryKey key, String defaultValue)
    {
        return this.dataRegistry.safeGetString(key,defaultValue);
    }

    protected void putInt(DataRegistryKey key, Integer value, int priority, boolean isSaveToDisk) {
        this.dataRegistry.putDataRegistry(
            new DataUnit(
                key,
                value.toString(),
                priority,
                this.getClass().getName(),
                isSaveToDisk
            )
        );
    }

    protected void putString(DataRegistryKey key, String value, int priority, boolean isSaveToDisk) {
        this.dataRegistry.putDataRegistry(
            new DataUnit(
                key,
                value,
                priority,
                this.getClass().getName(),
                isSaveToDisk
            )
        );
    }

    protected void putBoolean(DataRegistryKey key, Boolean value, int priority, boolean isSaveToDisk) {
        this.dataRegistry.putDataRegistry(
            new DataUnit(
                key,
                value.toString(),
                priority,
                this.getClass().getName(),
                isSaveToDisk
            )
        );
    }

    protected void putFloat(DataRegistryKey key, Float value, int priority, boolean isSaveToDisk) {
        this.dataRegistry.putDataRegistry(
            new DataUnit(
                key,
                value.toString(),
                priority,
                this.getClass().getName(),
                isSaveToDisk
            )
        );
    }
}
