package io.adbrix.sdk.data;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.CoreUtils;

public class S3ConfigHandler {
    protected static boolean config_ADBRIX_PAUSE;
    protected static boolean config_ADBRIX_ALL_STOP;
    public static JSONArray config_blockedEventList;
    public static long config_appScanPeriod;
    public static boolean config_appScanStop;
    public static int config_propertyMaxSize = ConfigConstants.CONFIG_DEFAULT_PROPERTY_MAX_SIZE;
    public static String config_sk_ip_port = ConfigConstants.CONFIG_DEFAULT_SK_IP_PORT;
    public static int config_sk_ping_version = ConfigConstants.CONFIG_DEFAULT_SK_PING_VERSION;
    public static int config_sk_ping_period_second = ConfigConstants.CONFIG_DEFAULT_SK_PING_PERIOD_SECOND;

    private S3ConfigHandler(){}

    private static class Singleton{
        private static final S3ConfigHandler instance = new S3ConfigHandler();
    }

    public static S3ConfigHandler getInstance(){
        return Singleton.instance;
    }

    public void initDefaultConfigValue(DataRegistry dataRegistry) {
        long tempLong;
        String tempStringArray;
        String tempString;

        tempStringArray = dataRegistry.safeGetString(DataRegistryKey.STRING_S3_CONFIG_BLOCKED_EVTLIST,null);
        if (tempStringArray != null) {
            try {
                config_blockedEventList = new JSONArray(tempStringArray);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        } else config_blockedEventList = ConfigConstants.CONFIG_DEFAULT_BLOCKED_EVENT_LIST;

        tempLong = dataRegistry.safeGetLong(DataRegistryKey.LONG_S3_CONFIG_APP_SCAN_PERIOD, -1);
        if (tempLong == -1)
            config_appScanPeriod = ConfigConstants.CONFIG_DEFAULT_APP_SCAN_PERIOD * 3600 * 1000;
        else config_appScanPeriod = (int) tempLong * 3600 * 1000;

        tempLong = dataRegistry.safeGetLong(DataRegistryKey.LONG_S3_CONFIG_APP_SCAN_STOP, -1);
        if (tempLong == -1) config_appScanStop = ConfigConstants.CONFIG_DEFAULT_APP_SCAN_ON_OFF;
        else config_appScanStop = tempLong == 1;

        tempLong = dataRegistry.safeGetLong(DataRegistryKey.LONG_S3_CONFIG_PROPERTY_KEY_MAX,-1);
        if (tempLong == -1)
            config_propertyMaxSize = ConfigConstants.CONFIG_DEFAULT_PROPERTY_MAX_SIZE;
        else config_propertyMaxSize = (int) tempLong;

        tempLong = dataRegistry.safeGetLong(DataRegistryKey.LONG_S3_CONFIG_ADBRIX_PAUSE,-1);
        if (tempLong == -1) config_ADBRIX_PAUSE = ConfigConstants.CONFIG_DEFAULT_ADBRIX_PAUSE;
        else config_ADBRIX_PAUSE = tempLong == 1 ? true : false;
        ABXBooleanState.getInstance().AdbrixPause.getAndSet(config_ADBRIX_PAUSE);

        tempLong = dataRegistry.safeGetLong(DataRegistryKey.LONG_S3_CONFIG_ADBRIX_ALL_STOP,-1);
        if (tempLong == -1)
            config_ADBRIX_ALL_STOP = ConfigConstants.CONFIG_DEFAULT_ADBRIX_ALL_STOP;
        else config_ADBRIX_ALL_STOP = tempLong == 1 ? true : false;
        ABXBooleanState.getInstance().AdbrixAllStop.getAndSet(config_ADBRIX_ALL_STOP);
        if(config_ADBRIX_ALL_STOP) ABXBooleanState.getInstance().AdbrixPause.getAndSet(config_ADBRIX_ALL_STOP);

        tempString = dataRegistry.safeGetString(DataRegistryKey.STRING_S3_CONFIG_SK_IP_PORT,null);
        if (tempString != null) {
            config_sk_ip_port = tempString;
        } else config_sk_ip_port = ConfigConstants.CONFIG_DEFAULT_SK_IP_PORT;

        tempLong = dataRegistry.safeGetInt(DataRegistryKey.INT_S3_CONFIG_SK_PING_VERSION,-1);
        if (tempLong == -1) {
            config_sk_ping_version = ConfigConstants.CONFIG_DEFAULT_SK_PING_VERSION;;
        } else config_sk_ping_version = (int) tempLong;

        tempLong = dataRegistry.safeGetInt(DataRegistryKey.INT_S3_CONFIG_SK_PING_PERIOD_SECOND,-1);
        if (tempLong == -1)
            config_sk_ping_period_second = ConfigConstants.CONFIG_DEFAULT_SK_PING_PERIOD_SECOND * 1000;
        else config_sk_ping_period_second = (int) tempLong * 1000;

        AbxLog.d("Initialized default value - adbrix pause       : " + config_ADBRIX_PAUSE,               true);
        AbxLog.d("Initialized default value - banned event list  : " + config_blockedEventList,           true);
//        AbxLog.d("Initialized default value - app scan period    : " + config_appScanPeriod/3600/1000,    true);
//        AbxLog.d("Initialized default value - app scan stop      : " + config_appScanStop,                true);
        AbxLog.d("Initialized default value - property max size  : " + config_propertyMaxSize,            true);
        AbxLog.d("Initialized default value - adbrix all stop    : " + config_ADBRIX_ALL_STOP,            true);
        AbxLog.d("Initialized default value - sk ip port         : " + config_sk_ip_port,                 true);
        AbxLog.d("Initialized default value - sk ping version    : " + config_sk_ping_version,            true);
        AbxLog.d("Initialized default value - sk ping period sec : " + config_sk_ping_period_second/1000, true);
    }

    public void parseResponseOfS3Config(String responseString, DataRegistry dataRegistry) {

        try {
            int temp;
            JSONObject jsonObjectFromS3Server;

            if (!CommonUtils.isNullOrEmpty(responseString))
                jsonObjectFromS3Server = new JSONObject(responseString);
            else return;

            temp = getDecryptedConfigValue(jsonObjectFromS3Server, ConfigConstants.S3_CONFIG_ADBRIX_PAUSE);
            if (temp != -1) {
                config_ADBRIX_PAUSE = temp == 1;

                dataRegistry.putDataRegistry(
                        new DataUnit(
                                DataRegistryKey.LONG_S3_CONFIG_ADBRIX_PAUSE,
                                (long) temp,
                                5,
                                this.getClass().getName(),
                                true
                        )
                );
                AbxLog.d("CONFIG::ADBRIX PAUSE : " + config_ADBRIX_PAUSE, true);
            }

            temp = getDecryptedConfigValue(jsonObjectFromS3Server, ConfigConstants.S3_CONFIG_ADBRIX_ALL_STOP);
            if (temp != -1) {
                config_ADBRIX_ALL_STOP = temp == 1;

                dataRegistry.putDataRegistry(
                        new DataUnit(
                                DataRegistryKey.LONG_S3_CONFIG_ADBRIX_ALL_STOP,
                                (long) temp,
                                5,
                                this.getClass().getName(),
                                true
                        )
                );
                AbxLog.d("CONFIG::ADBRIX ALL STOP : " + config_ADBRIX_ALL_STOP, true);
            }

            temp = getDecryptedConfigValue(jsonObjectFromS3Server, ConfigConstants.S3_CONFIG_APP_SCAN_PERIOD);
            if (temp != -1) {
                config_appScanPeriod = temp * 3600 * 1000; // period : per hour

                dataRegistry.putDataRegistry(
                        new DataUnit(
                                DataRegistryKey.LONG_S3_CONFIG_APP_SCAN_PERIOD,
                                (long) temp,
                                5,
                                this.getClass().getName(),
                                true
                        )
                );
//                AbxLog.d("CONFIG::APPSCAN PERIOD : " + temp, true);

                AbxLog.d("AbxApplicationScan:: DEPRECATED!!!", true);
            }

            temp = getDecryptedConfigValue(jsonObjectFromS3Server, ConfigConstants.S3_CONFIG_APP_SCAN_STOP);
            if (temp != -1) {
                config_appScanStop = temp == 1;

                dataRegistry.putDataRegistry(
                        new DataUnit(
                                DataRegistryKey.LONG_S3_CONFIG_APP_SCAN_STOP,
                                (long) temp,
                                5,
                                this.getClass().getName(),
                                true
                        )
                );
//                AbxLog.d("CONFIG::APPSCAN STOP : " + config_appScanStop, true);
                  AbxLog.d("AbxApplicationScan:: DEPRECATED!!!", true);
            }

            temp = getDecryptedConfigValue(jsonObjectFromS3Server, ConfigConstants.S3_CONFIG_PROPERTY_KEY_MAX);
            if (temp != -1) {
                config_propertyMaxSize = temp;

                dataRegistry.putDataRegistry(
                        new DataUnit(
                                DataRegistryKey.LONG_S3_CONFIG_PROPERTY_KEY_MAX,
                                (long) temp,
                                5,
                                this.getClass().getName(),
                                true
                        )
                );
                AbxLog.d("CONFIG::PROPERTY MAX SIZE : " + config_propertyMaxSize, true);
            }

            if (jsonObjectFromS3Server.has(ConfigConstants.S3_CONFIG_BLOCKED_EVTLIST)) {
                if (jsonObjectFromS3Server.get(ConfigConstants.S3_CONFIG_BLOCKED_EVTLIST) instanceof JSONArray) {
                    config_blockedEventList = (JSONArray) jsonObjectFromS3Server.get(ConfigConstants.S3_CONFIG_BLOCKED_EVTLIST);

                    dataRegistry.putDataRegistry(
                            new DataUnit(
                                    DataRegistryKey.STRING_S3_CONFIG_BLOCKED_EVTLIST,
                                    config_blockedEventList.toString(),
                                    5,
                                    this.getClass().getName(),
                                    true
                            )
                    );
                    AbxLog.d("CONFIG::BANNED LIST : " + config_blockedEventList.toString(), true);
                }
            }

            if (jsonObjectFromS3Server.has(ConfigConstants.S3_CONFIG_SK_IP_PORT)){
                if (jsonObjectFromS3Server.get(ConfigConstants.S3_CONFIG_SK_IP_PORT) instanceof String){
                    config_sk_ip_port = (String) jsonObjectFromS3Server.get(ConfigConstants.S3_CONFIG_SK_IP_PORT);
                    if(config_sk_ip_port.length() != 17){
                        AbxLog.d("CONFIG::SK IP PORT : " + "Wrong SK_IP_PORT!!", true);
                    }else {
                        dataRegistry.putDataRegistry(
                                new DataUnit(
                                        DataRegistryKey.STRING_S3_CONFIG_SK_IP_PORT,
                                        config_sk_ip_port,
                                        5,
                                        this.getClass().getName(),
                                        true
                                )
                        );
                        AbxLog.d("CONFIG::SK IP PORT : " + config_sk_ip_port, true);
                    }
                }
            }

            temp = getDecryptedConfigValue(jsonObjectFromS3Server, ConfigConstants.S3_CONFIG_SK_PING_VERSION);
            if (temp != -1) {
                config_sk_ping_version = temp;

                dataRegistry.putDataRegistry(
                        new DataUnit(
                                DataRegistryKey.INT_S3_CONFIG_SK_PING_VERSION,
                                temp,
                                5,
                                this.getClass().getName(),
                                true
                        )
                );
                AbxLog.d("CONFIG::SK PING VER : " + config_sk_ping_version, true);
            }

            temp = getDecryptedConfigValue(jsonObjectFromS3Server, ConfigConstants.S3_CONFIG_SK_PING_PERIOD_SECOND);
            if (temp != -1) {
                config_sk_ping_period_second = temp;

                dataRegistry.putDataRegistry(
                        new DataUnit(
                                DataRegistryKey.INT_S3_CONFIG_SK_PING_PERIOD_SECOND,
                                temp,
                                5,
                                this.getClass().getName(),
                                true
                        )
                );
                AbxLog.d("CONFIG::SK PING PERIOD SEC : " + config_sk_ping_period_second, true);
            }

        } catch (JSONException e) {
            AbxLog.d("CONFIG : The format received from server is not valid. Can't create new JSONObject.", true);
            e.printStackTrace();
        }
    }

    private int getDecryptedConfigValue(JSONObject objFromServer, String type) {
        String md5Hash;
        if (objFromServer.has(type)) {
            try {
                Object temp = objFromServer.get(type);
                String tempToString = "";
                if (temp instanceof String) tempToString = (String) temp;
                md5Hash = CoreUtils.get02XMD5(tempToString);
                if (ConfigConstants.S3Key.containsKey(md5Hash)) {
                    return ConfigConstants.S3Key.get(md5Hash);
                }
            } catch (JSONException e) {
                e.printStackTrace();
                return -1;
            }
        }
        return -1;
    }
}
