package io.adbrix.sdk.data;

import java.util.concurrent.atomic.AtomicBoolean;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;

public class ABXBooleanState {
    public AtomicBoolean AdbrixPause = new AtomicBoolean();
    public AtomicBoolean AdbrixAllStop = new AtomicBoolean();
    public AtomicBoolean AdbrixError = new AtomicBoolean();
    public AtomicBoolean sdkInitializedFlag = new AtomicBoolean(false);
    public AtomicBoolean inForeground = new AtomicBoolean(false);
    public AtomicBoolean isGdprForgetMe = new AtomicBoolean(false);
    public AtomicBoolean isGdprForgetMeSync = new AtomicBoolean(false);
    public AtomicBoolean isDebugAppInstalled = new AtomicBoolean(false);
    public AtomicBoolean isFirstOnResume = new AtomicBoolean(true);
    public AtomicBoolean isSessionStarted = new AtomicBoolean(false);

    private ABXBooleanState(){}

    private static class Singleton{
        private static final ABXBooleanState instance = new ABXBooleanState();
    }

    public static ABXBooleanState getInstance(){
        return Singleton.instance;
    }

    public void getGdprData(DataRegistry dataRegistry){
        isGdprForgetMe.getAndSet(dataRegistry.safeGetLong(DataRegistryKey.LONG_GDPR_FORGETME,0L) == 1L);
        isGdprForgetMeSync.getAndSet(dataRegistry.safeGetLong(DataRegistryKey.LONG_GDPR_FORGETME_SERVER_SYNC, 0L) == 1L);
        AbxLog.d("SDK GDPR Status :: is_gdpr_forget_me = "+ isGdprForgetMe.get() +", is_gdpr_forget_me_sync = "+ isGdprForgetMeSync.get(), true);
    }

    public boolean isAdbrixPause(){
        return AdbrixPause.get();
    }

    public boolean isAdbrixAllStop(){
        return AdbrixAllStop.get();
    }

    public boolean isAdbrixError(){
        return AdbrixError.get();
    }

    public boolean isSdkInitialized(){
        return sdkInitializedFlag.get();
    }

    public boolean inForeground(){
        return inForeground.get();
    }

    public boolean isGdprForgetMe(){
        return isGdprForgetMe.get();
    }

    public boolean isGdprForgetMeSync(){
        return isGdprForgetMeSync.get();
    }

    public boolean isDebugAppInstalled(){
        return isDebugAppInstalled.get();
    }

    public boolean isFirstOnResume(){
        return isFirstOnResume.get();
    }

    public boolean isSessionStarted() {
        return isSessionStarted.get();
    }
}
