package io.adbrix.sdk.component.autoEvent;

import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.TimerGroup;
import io.adbrix.sdk.configuration.IABXContext;
import io.adbrix.sdk.data.ABXBooleanState;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.interactor.SyncApplicationConfigureUseCase;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.CoreUtils;

public class DailyFirstOpenAutoEventGenerator {
    private String abxDailyFirstOpenDateTime = null;
    private Boolean sendDailyFirstOpenEvent;
    private IABXContext abxContext;
    private DataRegistry dataRegistry;
    private Repository repository;

    public DailyFirstOpenAutoEventGenerator(IABXContext abxContext, DataRegistry dataRegistry, Repository repository){
        this.abxContext = abxContext;
        this.dataRegistry = dataRegistry;
        this.repository = repository;
    }

    public void process(){
        Timer timer = new Timer();
        TimerGroup.getInstance().setDailyFirstOpenTimer(timer);
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                doTask();
            }
        }, 60_000, 60_000);
    }

    private void doTask() {
        if (ABXBooleanState.getInstance().isAdbrixAllStop() ||
                ABXBooleanState.getInstance().isAdbrixError()){
            return;
        }
        try {

            abxDailyFirstOpenDateTime = dataRegistry.safeGetString(DataRegistryKey.STRING_DAILY_FIRST_OPEN_PREV_DATE,null);

            String tempNowDate = CoreUtils.getDateViaGMTDateFormat(CoreConstants.ABX_DATE_FORMAT_SIMPLE);
            String tempPrevDate = abxDailyFirstOpenDateTime;
            if (sendDailyFirstOpenEvent == null) {
                if (dataRegistry.safeGetString(DataRegistryKey.STRING_SEND_DAILY_FIRST_OPEN_EVT,null) == null) {
                    sendDailyFirstOpenEvent = false;
                } else {
                    sendDailyFirstOpenEvent = Boolean.valueOf(dataRegistry.safeGetString(DataRegistryKey.STRING_SEND_DAILY_FIRST_OPEN_EVT,null));
                }
            }
            // at the first time ( i.e. First Open )
            if (CommonUtils.isNullOrEmpty(tempPrevDate)) {
                dataRegistry.putDataRegistry(new DataUnit(
                        DataRegistryKey.STRING_DAILY_FIRST_OPEN_PREV_DATE,
                        tempNowDate,
                        5,
                        this.getClass().getName(),
                        true));

                abxDailyFirstOpenDateTime = tempNowDate;
                tempPrevDate = tempNowDate;
            }

            AbxLog.i("Daily First Open... " + "NOW : " + tempNowDate + " , PREV : " + tempPrevDate, true);

            if (!tempPrevDate.equals(tempNowDate)) {

                clearNotificationStore();

                dataRegistry.putDataRegistry(new DataUnit(
                        DataRegistryKey.STRING_DAILY_FIRST_OPEN_PREV_DATE,
                        tempNowDate,
                        5,
                        this.getClass().getName(),
                        true));

                sendDailyFirstOpenEvent = true;

                dataRegistry.putDataRegistry(new DataUnit(
                        DataRegistryKey.STRING_SEND_DAILY_FIRST_OPEN_EVT,
                        sendDailyFirstOpenEvent.toString(),
                        5,
                        this.getClass().getName(),
                        true));

                new SyncApplicationConfigureUseCase(repository).execute();
            }
            if (ABXBooleanState.getInstance().inForeground() && sendDailyFirstOpenEvent) {
                sendDailyFirstOpenEvent = false;

                dataRegistry.putDataRegistry(new DataUnit(
                        DataRegistryKey.STRING_SEND_DAILY_FIRST_OPEN_EVT,
                        sendDailyFirstOpenEvent.toString(),
                        5,
                        this.getClass().getName(),
                        true));

                if (!ABXBooleanState.getInstance().isAdbrixPause()) {
                    LogEventParameter eventParameter = new LogEventParameter(
                            CoreConstants.GROUP_ABX,
                            CoreConstants.EVENT_DAILY_FIRSTOPEN,
                            null,
                            0,
                            0);

                    this.abxContext.logEvent(eventParameter);
                }
            }
            abxDailyFirstOpenDateTime = tempNowDate;

        } catch (Exception e) {
            AbxLog.e(Arrays.toString(e.getStackTrace()), true);
        }
    }

    private void clearNotificationStore(){
        dataRegistry.putDataRegistry(new DataUnit(
                DataRegistryKey.STRING_ABX_NOTIFICATION_ID,
                "",
                5,
                this.getClass().getName(),
                true));
    }
}
