package io.adbrix.sdk.component;

import android.util.Log;

public interface ILogger {

    enum LogLevel
    {
        VERBOSE(Log.VERBOSE),
        DEBUG(Log.DEBUG),
        INFO(Log.INFO),
        WARN(Log.WARN),
        ERROR(Log.ERROR),
        ASSERT(Log.ASSERT);

        public int androidLogLevel;
        LogLevel(int androidLogLevel)
        {
            this.androidLogLevel = androidLogLevel;
        }

        public int getAndroidLogLevel(){
            return this.androidLogLevel;
        }
    }

    void setLogLevel(LogLevel level);
    void debug(String message);
    void error(String message);
    void verbose(String message);
    void info(String message);
    void warn(String message);
}
