package io.adbrix.sdk.component;

import java.util.ArrayList;
import java.util.List;

public class DeeplinkPostingObservable implements IObservable<String>{
    private List<IObserver<String>> observers = new ArrayList<>();

    private DeeplinkPostingObservable(){}

    private static class Singleton{
        private static final DeeplinkPostingObservable instance = new DeeplinkPostingObservable();
    }

    public static DeeplinkPostingObservable getInstance(){
        return Singleton.instance;
    }

    @Override
    public void add(IObserver<String> observer) {
        observers.add(observer);
    }

    @Override
    public void delete(IObserver<String> observer) {
        observers.remove(observer);
    }

    @Override
    public void notifyObserver(String object) {
        for (IObserver<String> observer : observers){
            observer.update(object);
        }
    }
}
