package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;


public class UserPropertyModel implements IDataModel{
    public final String user_snapshot_id;
    public final Map<String, Object> properties;

    public UserPropertyModel(String user_snapshot_id, Map<String, Object> properties) {
        this.user_snapshot_id = user_snapshot_id;
        this.properties = properties;
    }

    @Override
    public JSONObject getJson() throws JSONException {

        JSONObject propertiesJson = new JSONObject();
        {
            for(String key : this.properties.keySet())
            {
                propertiesJson.put(key,this.properties.get(key));
            }
        }
        return propertiesJson;
    }
}
