package io.adbrix.sdk.domain.model;

import io.adbrix.sdk.domain.CoreConstants;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventBundleModel implements IApiModel{
    private JSONObject common;
    private JSONArray evts;

    public EventBundleModel(JSONObject common, JSONArray evts){
        this.common = common;
        this.evts = evts;
    }

    @Override
    public String getUrlString() {
        return CoreConstants.BULK_EVENT_TRACKING_URL_TEMPLATE;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject root = new JSONObject();
        root.put("common", common);
        root.put("evts", evts);

        return root;
    }
}
