package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

public class CommonModel implements IDataModel {
    public final String request_datetime;
    public final IdentityModel identity_info;
    public final DeviceModel device_info;
    public final String package_name;
    public final String appkey;
    public final String api_version;
    public final String sdk_version;
    public final String installer;
    public final String app_version;
    public final String build_id;

    public CommonModel(
            String request_datetime,
            IdentityModel identity_info,
            DeviceModel device_info,
            String package_name,
            String appkey,
            String api_version,
            String sdk_version,
            String installer,
            String app_version,
            String build_id
    ) {
        this.request_datetime = request_datetime;
        this.identity_info = identity_info;
        this.device_info = device_info;
        this.package_name = package_name;
        this.appkey = appkey;
        this.api_version = api_version;
        this.sdk_version = sdk_version;
        this.installer = installer;
        this.app_version = app_version;
        this.build_id = build_id;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject root = new JSONObject();
        {
            root.put("request_datetime", this.request_datetime);
            root.put("identity", this.identity_info.getJson());
            root.put("device_info", this.device_info.getJson());
            root.put("package_name", this.package_name);
            root.put("appkey", this.appkey);
            root.put("api_version", this.api_version);
            root.put("sdk_version", this.sdk_version);
            root.put("installer", this.installer);
            root.put("app_version", this.app_version);
            root.put("build_id", this.build_id);
        }
        return root;
    }
}
