package io.adbrix.sdk.domain;

import io.adbrix.sdk.data.net.ApiConnectionManager;
import io.adbrix.sdk.domain.model.EventModel;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.domain.model.UserPropertyCommand;

public interface Repository {
    EventModel getEventModel(LogEventParameter logEventParameter);

    Boolean saveUserPropertyWithoutEvent(UserPropertyCommand userPropertyCommand);
    void initDefaultConfigValue();
    void syncApplicationConfigure();
    void gdprForgetMe();
//    void updateFavoriteApplication();
    void registerNetworkCallback();
    void saveUnsentEvents();
    void logEvent(LogEventParameter logEventParameter);
    void flushAllNow();
    void flushAtIntervals();
    void deleteUserData(String userId, ApiConnectionManager.Result result);
    void restartSDK(String userId, ApiConnectionManager.Result result);
}
