package io.adbrix.sdk.data.modelprovider;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Arrays;
import java.util.Map;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.data.repository.UserPropertyManager;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.domain.model.EventModel;
import io.adbrix.sdk.domain.model.IDataModel;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.domain.model.UserPropertyModel;
import io.adbrix.sdk.utils.CommonUtils;

public class EventModelProvider implements IDataModelProvider {
    UserPropertyManager userPropertyManager;
    DataRegistry dataRegistry;
    LogEventParameter logEventParameter;

    public EventModelProvider(
            UserPropertyManager userPropertyManager,
            DataRegistry dataRegistry)
    {
        this.userPropertyManager = userPropertyManager;
        this.dataRegistry = dataRegistry;
    }

    public void setLogEventParameter(LogEventParameter logEventParameter) {
        this.logEventParameter = logEventParameter;
    }

    @Override
    public IDataModel provide() {

        EventModel.Location location = new EventModel.Location(
            this.dataRegistry.safeGetString(DataRegistryKey.STRING_LOCATION_LWID, null),
            this.dataRegistry.safeGetDouble(DataRegistryKey.DOUBLE_LOCATION_LAT,  0.0d),
            this.dataRegistry.safeGetDouble(DataRegistryKey.DOUBLE_LOCATION_LNG,  0.0d)
        );

        UserPropertyModel userPropertyModel = this.userPropertyManager.getCurrentUserPropertyModel();

        EventModel eventModel = new EventModel(
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_LAST_FIRSTOPEN_ID, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_LAST_DEEPLINK_ID, null),
                this.dataRegistry.safeGetString(DataRegistryKey.STRING_LAST_OPEN_ID, null),
                getPrevId(logEventParameter),
                getEventDatetime(logEventParameter),
                logEventParameter.group,
                logEventParameter.eventName,
                logEventParameter.eventParam,
                logEventParameter.sessionInterval,
                logEventParameter.sessionLength,
                logEventParameter.eventId,
                getSessionId(logEventParameter.eventName),
                location,
                userPropertyModel.user_snapshot_id,
                getUserPropertyJSONObject(userPropertyModel),
                getCiJSONObject(userPropertyModel)
        );
        return eventModel;
    }

    private String getPrevId(LogEventParameter logEventParameter){
        if (logEventParameter.prevId != null)
            return logEventParameter.prevId;
        else
            return this.dataRegistry.safeGetString(DataRegistryKey.STRING_PREV_ID, null);
    }

    private String getEventDatetime(LogEventParameter logEventParameter){
        if (logEventParameter.event_datetime == null)
            return CommonUtils.getCurrentUTCInDBFormat();
        else
            return logEventParameter.event_datetime;
    }

    private String getSessionId(String sessionType) {
        if (CoreConstants.EVENT_END_SESSION.equals(sessionType)) {
            return this.dataRegistry.safeGetString(DataRegistryKey.STRING_LAST_END_SESSION_ID, null);
        }
        return this.dataRegistry.safeGetString(DataRegistryKey.STRING_LAST_CREATED_SESSION_ID, null);
    }

    private JSONObject getUserPropertyJSONObject(UserPropertyModel userPropertyModel) {
        JSONObject userPropertyJson = new JSONObject();
        try {
            for (Map.Entry<String, Object> entry : userPropertyModel.properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();

                if (!key.startsWith(CoreConstants.CI_KEY)) {
                    if (CoreConstants.ABX_USER_PROPERTY_KEY_LIST.contains(key)) {
                        userPropertyJson.put("abx:" + key, value);
                    } else {
                        userPropertyJson.put("c:" + key, value);
                    }
                }
            }
        } catch (JSONException e){
            AbxLog.e(Arrays.toString(e.getStackTrace()), true);
        }

        return userPropertyJson;
    }

    private JSONObject getCiJSONObject(UserPropertyModel userPropertyModel){
        JSONObject ciJson = new JSONObject();
        try {
            for (Map.Entry<String, Object> entry : userPropertyModel.properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();

                if (key.startsWith(CoreConstants.CI_KEY)) {
                    key = key.replace(CoreConstants.CI_KEY, "");
                    if (CoreConstants.ABX_CI_KEY_LIST.contains(key)) {
                        ciJson.put("abx:" + key, value);
                    }
                    else {
                        ciJson.put("c:" + key, value);
                    }
                }
            }
        } catch (JSONException e){
            AbxLog.e(Arrays.toString(e.getStackTrace()), true);
        }

        return ciJson;
    }
}
