package io.adbrix.sdk.data.entity;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.domain.model.IDataModel;

public class DataUnit implements IDataModel {

    public static class DataUnitInvalidTypeCastingException extends Exception
    {

    }

    public final DataRegistryKey key;
    public final DataType dataType;
    public final String src_value;
    public final int priority;
    public final String provider;
    public final boolean is_persistence;

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject root = new JSONObject();
        root.put("key",             this.key.getId());
        root.put("src_value",       this.src_value);
        root.put("priority",        this.priority);
        root.put("provider",        this.provider);
        root.put("is_persistence",  this.is_persistence);

        return root;
    }

    public DataUnit(
            DataRegistryKey key,
            Object src_value,
            int priority,
            String provider,
            boolean is_persistence
    ) {
        this.key = key;
        this.dataType = this.key.getDataType();
        this.src_value = src_value == null ? null : src_value.toString();
        this.priority = priority;
        this.provider = provider;
        this.is_persistence = is_persistence;
    }

    public int getInt() throws DataUnitInvalidTypeCastingException {
        if(this.dataType != DataType.INT)
            throw new DataUnitInvalidTypeCastingException();

        return Integer.parseInt(this.src_value);
    }

    public String getString() throws DataUnitInvalidTypeCastingException {
        if(this.dataType != DataType.STRING)
            throw new DataUnitInvalidTypeCastingException();

        return this.src_value;
    }

    public boolean getBoolean() throws DataUnitInvalidTypeCastingException {
        if(this.dataType != DataType.BOOLEAN)
            throw new DataUnitInvalidTypeCastingException();

        return Boolean.parseBoolean(this.src_value);
    }

    public float getFloat() throws DataUnitInvalidTypeCastingException {
        if(this.dataType != DataType.FLOAT)
            throw new DataUnitInvalidTypeCastingException();

        return Float.parseFloat(this.src_value);
    }

    public long getLong() throws DataUnitInvalidTypeCastingException {
        if(this.dataType != DataType.LONG)
            throw new DataUnitInvalidTypeCastingException();

        return Long.parseLong(this.src_value);
    }

    public double getDouble() throws DataUnitInvalidTypeCastingException {
        if(this.dataType != DataType.DOUBLE)
            throw new DataUnitInvalidTypeCastingException();

        return Double.parseDouble(this.src_value);
    }
}
