package io.adbrix.sdk.configuration;

import android.app.Activity;
import android.content.Context;

import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.net.ApiConnectionManager;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.domain.model.UserPropertyCommand;

public interface IABXContext {
    void initialize(Context context, String appkey, String secretkey);
    void saveUserProperty(UserPropertyCommand userPropertyCommand);
    Boolean saveUserPropertyWithoutEvent(UserPropertyCommand userPropertyCommand);
    void logEvent(LogEventParameter logEventParameter);
    void runOnIdleTime();
    void onResume(Activity activity);
    void onPause();
    void deeplink(Activity deeplinkActivity);
    void putDataRegistry(DataUnit dataUnit);
    void registerNetworkCallback();
    void deleteUserData(String userId, ApiConnectionManager.Result result);
    void restartSDK(String userId, ApiConnectionManager.Result result);
}
