package io.adbrix.sdk.configuration;

import android.app.Activity;
import android.content.Context;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.net.ApiConnectionManager;
import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.interactor.DeleteUserDataUseCase;
import io.adbrix.sdk.domain.interactor.RestartSDKUseCase;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.domain.model.UserPropertyCommand;

public class DisabledABXContext implements IABXContext {

    private static final String WARNING_FOR_DISABLED_CONTEXT = "Disabled된 ABX SDK의 Method가 호출되었습니다.";
    private final Repository repository;

    public DisabledABXContext(String disabledReason, Repository repository) {
        AbxLog.d( "ABX SDK가 Disabled 되었습니다. 이유는 = "+ disabledReason, true);
        this.repository = repository;
    }

    @Override
    public void initialize(Context context, String appkey, String secretkey) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, true);
    }

    @Override
    public void saveUserProperty(UserPropertyCommand userPropertyCommand) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, true);
    }

    @Override
    public Boolean saveUserPropertyWithoutEvent(UserPropertyCommand userPropertyCommand) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, true);
        return null;
    }

    @Override
    public void logEvent(LogEventParameter logEventParameter) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, true);
    }

    @Override
    public void runOnIdleTime() {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void onResume(Activity activity) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void onPause() {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void deeplink(Activity deeplinkActivity) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void putDataRegistry(DataUnit dataUnit) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void registerNetworkCallback() {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void deleteUserData(String userId, ApiConnectionManager.Result result) {
        AbxLog.d("Delete user data api called!", true);

        new DeleteUserDataUseCase(repository, result).execute(userId);
    }

    @Override
    public void restartSDK(String userId, ApiConnectionManager.Result result) {
        AbxLog.d("Restart SDK api called!", true);

        new RestartSDKUseCase(repository, result).execute(userId);
    }
}
