package io.adbrix.sdk.component;

import java.util.Timer;

public class TimerGroup {

    private static class Singleton {
        private static final TimerGroup instance = new TimerGroup();
    }

    public static TimerGroup getInstance() {
        return Singleton.instance;
    }

    private Timer dailyFirstOpenTimer;
    private Timer skTimer;
    private Timer eventBusTimer;

    public void setEventBusTimer(Timer eventBusTimer) {
        this.eventBusTimer = eventBusTimer;
    }

    public void setSkTimer(Timer skTimer) {
        this.skTimer = skTimer;
    }

    public void setDailyFirstOpenTimer(Timer dailyFirstOpenTimer) {
        this.dailyFirstOpenTimer = dailyFirstOpenTimer;
    }

    public void cancelAll() {
        if (dailyFirstOpenTimer != null) {
            dailyFirstOpenTimer.cancel();
        }

        if (skTimer != null) {
            skTimer.cancel();
        }

        if (eventBusTimer != null) {
            eventBusTimer.cancel();
        }
    }
}
