package io.adbrix.sdk.component;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class PushOpenMonitor {

    private AtomicBoolean isOpenedByPush;
    private Map<String, Object> pushOpenEventParam;

    private PushOpenMonitor(){
        isOpenedByPush = new AtomicBoolean(false);
    }

    private static class Singleton{
        private static final PushOpenMonitor instance = new PushOpenMonitor();
    }

    public static PushOpenMonitor getInstance(){
        return Singleton.instance;
    }

    public Map<String, Object> getPushOpenEventParam() {
        return pushOpenEventParam;
    }

    public void setPushOpenEventParam(Map<String, Object> pushOpenEventParam) {
        this.pushOpenEventParam = pushOpenEventParam;
    }

    public void setOpenedByPush(boolean openedByPush) {
        isOpenedByPush.getAndSet(openedByPush);
    }

    public boolean isOpenedByPush() {
        return isOpenedByPush.get();
    }

    public void refresh(){
        isOpenedByPush.getAndSet(false);
    }
}
