package io.adbrix.sdk.component;

import android.os.Handler;
import android.os.Looper;

import io.adbrix.sdk.utils.CoreUtils;

import java.util.ArrayList;
import java.util.List;

public class DeferredDeeplinkPostingObservable implements IObservable<String> {
    private List<IObserver<String>> observers = new ArrayList<>();
    private Handler mainThreadHandler = new Handler(Looper.getMainLooper());

    private DeferredDeeplinkPostingObservable() {}

    private static class Singleton{
        private static final DeferredDeeplinkPostingObservable instance = new DeferredDeeplinkPostingObservable();
    }

    public static DeferredDeeplinkPostingObservable getInstance(){
        return Singleton.instance;
    }

    @Override
    public void add(IObserver<String> observer) {
        observers.add(observer);
    }

    @Override
    public void delete(IObserver<String> observer) {
        observers.remove(observer);
    }

    @Override
    public void notifyObserver(String deferredDeeplink) {
        for (IObserver<String> observer : observers){
            observer.update(deferredDeeplink);
        }
    }

    public void postDeferredDeeplinkToMainThread(String uriStr) {
        mainThreadHandler.post(new Runnable() {
            @Override
            public void run() {
                String deferredDeeplink = CoreUtils.getValueOfJsonObject(uriStr, "deeplink");
                notifyObserver(deferredDeeplink);
            }
        });
    }
}
