package io.adbrix.sdk.component;

import android.util.Log;

public class DefaultLogger implements ILogger {

    private LogLevel logLevel;

    public DefaultLogger(){
        this.logLevel = LogLevel.VERBOSE; //기본값은 모든 로그 출력
    }

    @Override
    public void setLogLevel(LogLevel level) {
        this.logLevel = level;
    }

    @Override
    public void debug(String message) {
        if(logLevel.androidLogLevel <= Log.DEBUG){
            AbxLog.d(message, true);
        }
    }

    @Override
    public void error(String message) {
        if(logLevel.androidLogLevel <= Log.ERROR){
            AbxLog.d(message, true);
        }
    }

    @Override
    public void verbose(String message) {
        if(logLevel.androidLogLevel <= Log.VERBOSE){
            AbxLog.d(message, true);
        }
    }

    @Override
    public void info(String message) {
        if(logLevel.androidLogLevel <= Log.INFO){
            AbxLog.d(message, true);
        }
    }

    @Override
    public void warn(String message) {
        if(logLevel.androidLogLevel <= Log.WARN){
            AbxLog.d(message, true);
        }
    }
}
