package io.adbrix.sdk.domain.model;

import java.util.Map;

import io.adbrix.sdk.utils.CommonUtils;

public class LogEventParameter {
    public final String createAt;
    public final String prevId;
    public String eventId;
    public final String group;
    public final String eventName;
    public final Map<String,Object> eventParam;
    public final long sessionInterval; // Only for startSession
    public final long sessionLength; // Only for endSession
    public String event_datetime;

    public LogEventParameter(
            String group,
            String eventName,
            Map<String,Object> eventParam,
            long sessionInterval,
            long sessionLength
    ) {
        this.createAt = CommonUtils.getCurrentUTCInDBFormat();
        this.prevId = null;
        this.eventId = CommonUtils.randomUUIDWithCurrentTime();
        this.group = group;
        this.eventName = eventName;
        this.eventParam = eventParam;
        this.sessionInterval = sessionInterval;
        this.sessionLength = sessionLength;
        this.event_datetime = null;
    }

    public LogEventParameter(
            String group,
            String eventName,
            Map<String,Object> eventParam,
            long sessionInterval,
            long sessionLength,
            String event_datetime
    ) {
        this.createAt = CommonUtils.getCurrentUTCInDBFormat();
        this.prevId = null;
        this.eventId = CommonUtils.randomUUIDWithCurrentTime();
        this.group = group;
        this.eventName = eventName;
        this.eventParam = eventParam;
        this.sessionInterval = sessionInterval;
        this.sessionLength = sessionLength;
        this.event_datetime = event_datetime;
    }

    public LogEventParameter(
            String eventId,
            String prevId,
            String group,
            String eventName,
            Map<String,Object> eventParam,
            long sessionInterval,
            long sessionLength,
            String event_datetime
    ){
        this.createAt = CommonUtils.getCurrentUTCInDBFormat();
        this.prevId = prevId;
        this.eventId = eventId;
        this.group = group;
        this.eventName = eventName;
        this.eventParam = eventParam;
        this.sessionInterval = sessionInterval;
        this.sessionLength = sessionLength;
        this.event_datetime = event_datetime;
    }
}
