package io.adbrix.sdk.domain.model;

import io.adbrix.sdk.domain.CoreConstants;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GDPRModel implements IApiModel{
    private String subject_request_id = null;
    private String subject_request_type = null;
    private String submitted_time = null;
    private JSONArray subject_identities = null;
    private String api_version = null;
    private String status_callback_urls = null;
    private JSONObject extensions = null;

    public GDPRModel(
            String subject_request_id,
            String subject_request_type,
            String submitted_time,
            JSONArray subject_identities,
            String api_version,
            String status_callback_urls,
            JSONObject extensions
    ){
        this.subject_request_id = subject_request_id;
        this.subject_request_type = subject_request_type;
        this.submitted_time = submitted_time;
        this.subject_identities = subject_identities;
        this.api_version = api_version;
        this.status_callback_urls = status_callback_urls;
        this.extensions = extensions;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject root = new JSONObject();
        root.put("subject_request_id", subject_request_id);
        root.put("subject_request_type", subject_request_type);
        root.put("submitted_time", submitted_time);
        root.put("subject_identities", subject_identities);
        root.put("api_version", api_version);
        root.put("status_callback_urls", status_callback_urls);
        root.put("extensions", extensions);

        return root;
    }

    @Override
    public String getUrlString() {
        return CoreConstants.GDPR_URL_REQ;
    }
}
