package io.adbrix.sdk.domain.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class EventPackage {

    public final List<EventModel> eventModels;
    public final String packageId;

    public EventPackage(List<EventModel> eventModels) {
        this.eventModels = eventModels;
        this.packageId = UUID.randomUUID().toString();
    }

    public JSONObject toJson() throws JSONException {
        JSONObject result = new JSONObject();
        JSONArray eventModelArray = new JSONArray();

        for (EventModel eventModel : eventModels){
            eventModelArray.put(eventModel.getJson());
        }
        result.put("eventModels", eventModelArray);

        return result;
    }

    public static EventPackage fromJson(JSONObject jsonObject) {
        JSONArray eventModelArray;
        List<EventModel> eventModelList = new ArrayList<>();

        try {
            eventModelArray = jsonObject.getJSONArray("eventModels");
        } catch (JSONException e) {
            e.printStackTrace();
            eventModelArray = new JSONArray();
        }

        try {
            for (int i = 0; i < eventModelArray.length(); i++) {
                eventModelList.add(EventModel.fromJson(eventModelArray.getJSONObject(i)));
            }
        } catch (JSONException e) {
            e.printStackTrace();
            return null;
        }

        return new EventPackage(eventModelList);
    }
}
