package io.adbrix.sdk.domain.model;

import io.adbrix.sdk.utils.CoreUtils;

import org.json.JSONException;
import org.json.JSONObject;

public class DeviceModel implements IDataModel{
    public String os;
    public String model;
    public String vendor;
    public String resolution;
    public String platform;
    public String carrier;
    public int time_zone_offset;
    public int device_time_type;
    public Boolean is_wifi_only;
    // EventModel로 migration이 예정되어 있는 property들
    public boolean is_portrait;
    public String network;
    public String language;
    public String country;
    public int batt_l;
    public boolean batt_c;

    public DeviceModel(
        String os,
        String model,
        String vendor,
        String resolution,
        String platform,
        String carrier,
        int time_zone_offset,
        int device_time_type,
        Boolean is_wifi_only,
        boolean is_portrait,
        String network,
        String language,
        String country,
        int batt_l,
        boolean batt_c
    ) {
        this.os = os;
        this.model = model;
        this.vendor = vendor;
        this.resolution = resolution;
        this.platform = platform;
        this.carrier = carrier;
        this.time_zone_offset = time_zone_offset;
        this.device_time_type = device_time_type;
        this.is_wifi_only = is_wifi_only;
        this.is_portrait = is_portrait;
        this.network = network;
        this.language = language;
        this.country = country;
        this.batt_l = batt_l;
        this.batt_c = batt_c;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        JSONObject root = new JSONObject();
        {
            root.put("os", this.os);
            root.put("model", this.model);
            root.put("vendor", this.vendor);
            root.put("resolution", this.resolution);
            root.put("is_portrait", this.is_portrait);
            root.put("platform", this.platform);
            root.put("network", this.network);
            root.put("carrier", this.carrier);
            root.put("language", this.language);
            root.put("country", CoreUtils.convertNullableToJSONNullable(this.country));
            root.put("time_zone_offset", this.time_zone_offset);
            root.put("device_time_type", this.device_time_type);
            root.put("is_wifi_only", this.is_wifi_only);
            root.put("batt_l", this.batt_l);
            root.put("batt_c", this.batt_c);
        }
        return root;
    }
}
