package io.adbrix.sdk.domain;

import java.util.Arrays;
import java.util.List;

import io.adbrix.sdk.component.AbxLog;

public class CoreConstants {

    private CoreConstants(){}

    public static final int EVENT_BUFFER_COUNT = 10;

    // 60 seconds timeout
    public static final int NETWORK_TIMEOUT = 60_000;
    public static final int SESSION_TIMEOUT = 60_000;
    public static final int BATCHING_INTERVAL = 60_000;
    public static final long PROVIDER_INITIALIZATION_TIMEOUT_MILLISECONDS = 5000;

    public static final String ABX_DATE_FORMAT_SIMPLE = "yyyyMMdd";
    public static final String DB_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public static final String GROUP_ABX = "abx";
    public static final String GROUP_CUSTOM = "custom";

    public static final String EVENT_START_SESSION = "start_session";
    public static final String EVENT_END_SESSION = "end_session";
    public static final String EVENT_FIRSTOPEN = "firstopen";
    public static final String EVENT_DAILY_FIRSTOPEN = "daily_first_open";
    public static final String EVENT_DEEPLINK_OPEN = "deeplink_open";
    public static final String EVENT_SET_PUSH = "set_push";
    public static final String EVENT_OPEN_PUSH = "open_push";

    public static final List<String> ABX_USER_PROPERTY_KEY_LIST = Arrays.asList("age", "gender", "user_id", "user_id_hash");
    public static final List<String> ABX_CI_KEY_LIST = Arrays.asList("kakao_id"); //, "phone_number");

    public static final String DEEPLINK_PAYLOAD = "abx:deeplink_payload";
    public static final String DEEPLINK_ABX_ADKEY = "abx:deeplink_adkey"; // abx_tid
    public static final String DEEPLINK_ABX_TID = "abx_tid";
    public static final String DEEPLINK_ABX_TRACKER_ID = "abx_tracker_id";
    public static final String DEEPLINK_ABX_URL = "adtouch.adbrix.io";

    public static final String SPECIAL_KEY = "SPECIAL_KEY";
    public static final String COMMERCE_KEY = "COMMERCE_KEY";

    public static final String PAGE_ABX_KEY = "abx:page";

    public static final int MAX_STRING_LENGTH = 1024;
    public static final int MAX_PROPERTY_KEYS = 100;
    public static final int MAX_PRODUCT_NUMBER = 50;
    public static final int USER_PROPERTY_MAX_KEY_LENGTH = 50;

    public static final String CI_KEY = "abxwalterci_";

    private static final String ABX_ENDPOINT_LIVE = "https://event.adbrix.io";
    private static final String ABX_ENDPOINT_DEV = "https://event-qa.adbrix.io";
    private static String ABX_ENDPOINT = ABX_ENDPOINT_LIVE;

    private static final String GDPR_ENDPOINT_PROD = "https://gdpr.adbrix.io";
    private static final String GDPR_ENDPOINT_DEV = "https://gdpr-qa.adbrix.io";
    private static String ABX_GDPR_ENDPOINT = GDPR_ENDPOINT_PROD;
    public static  String GDPR_URL_REQ = ABX_GDPR_ENDPOINT + "/api/opengdpr_requests";

    private static final String CONFIG_REQUEST_PROD_URL = "https://static.adbrix.io/prod/sdk.config/%s/config.json";
    public static final String CONFIG_REQUEST_URL_ADBRIX = "https://static.adbrix.io/sdk.config/%s/config.json";
    private static final String CONFIG_REQUEST_DEV_URL = "https://static.adbrix.io/dev/sdk.config/%s/config.json";
    public static String CONFIG_REQUEST_URL =CONFIG_REQUEST_PROD_URL;

    public static String CONFIG_REQUEST_URL_FOR_ADBRIX = ABX_ENDPOINT + "";
    public static String DEFERRED_DEEPLINK_URL_REQ = ABX_ENDPOINT + "/api/v5/deferred-deeplink/%s";
    public static String USER_PROFILE_URL_TEMPLATE = ABX_ENDPOINT + "/api/v4/users/%s";
    public static String BULK_EVENT_TRACKING_URL_TEMPLATE = ABX_ENDPOINT + "/api/v5/event/bulk/%s";
    public static String SINGLE_EVENT_TRACKING_URL_TEMPLATE = ABX_ENDPOINT + "/api/v4/event/single/%s";

//    private static final String APP_SCANNING_PROD_URL = "https://stream.adbrix.io/api/v4/record/put/abxas/%s";
//    private static final String APP_SCANNING_DEV_URL = "https://stream-dev.adbrix.io/api/v4/record/put/abxas/%s";
//    public static String APP_SCAN_URL = APP_SCANNING_DEV_URL;

    public static void setDevState(boolean isDevState){

        ABX_ENDPOINT = isDevState ? ABX_ENDPOINT_DEV : ABX_ENDPOINT_LIVE;

        ABX_GDPR_ENDPOINT = isDevState ? GDPR_ENDPOINT_DEV : GDPR_ENDPOINT_PROD;
        GDPR_URL_REQ = ABX_GDPR_ENDPOINT + "/api/opengdpr_requests";
        SINGLE_EVENT_TRACKING_URL_TEMPLATE = ABX_ENDPOINT + "/api/v4/event/single/%s";
        BULK_EVENT_TRACKING_URL_TEMPLATE = ABX_ENDPOINT + "/api/v5/event/bulk/%s";
        USER_PROFILE_URL_TEMPLATE = ABX_ENDPOINT + "/api/v4/users/%s";
        DEFERRED_DEEPLINK_URL_REQ = ABX_ENDPOINT + "/api/v5/deferred-deeplink/%s";
        CONFIG_REQUEST_URL_FOR_ADBRIX = ABX_ENDPOINT + "";
        CONFIG_REQUEST_URL = isDevState ? CONFIG_REQUEST_DEV_URL : CONFIG_REQUEST_PROD_URL;

        if(isDevState){
            AbxLog.d("END POINT is changed from ABX_LIVE_SERVER to ABX_DEV_SERVER",true);
        }
    }
}
