package io.adbrix.sdk.data.repository.datasource;

import android.content.Context;
import android.content.SharedPreferences;

public class DefaultDataContext implements IDataContext {
    private Context context;
    // XML 파일이 MultiThread 환경에서 이슈가 있었다고 한다.
    private SharedPreferences data;
    public DefaultDataContext(Context context)
    {
        this.context = context;
        this.data = this.context.getSharedPreferences(getFileName(), Context.MODE_PRIVATE);
    }

    // Commit Method는 Main thread에서 작동하면 안된다. (Blocking)
    // Apply Method는 Background에서 동작하므로 Non-blocking이지만 그 Operation의 성패 여부를 반환하지 않는다.
    @Override
    public void setValue(String key, String value) {
        data.edit()
            .putString(key, value)
            .apply();
    }

    @Override
    public String getValueOrNull(String key) {
        return data.getString(key, null);
    }

    // key가 있을 시 remove하고 true를 반환한다. key가 없을 시 false를 반환한다.
    public boolean tryRemove(String key) {
        if(data.contains(key))
        {
            data.edit()
                .remove(key)
                .apply();
            return true;
        }
        else
        {
            return false;
        }
    }

    public void clear() {
        data.edit()
            .clear()
            .apply();
    }

    private String getFileName() {
        // read, write될 XML File의 이름이다. 따로 ABXConstants에 저장할 수도 있지만, 당장은 Method로 빼놓았다.
        return "shared_prefs"+":"+this.getClass().getName();
    }
}
