package io.adbrix.sdk.data.modelprovider;

import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.DeferredDeeplinkModel;
import io.adbrix.sdk.domain.model.IApiModel;

public class DeferredDeeplinkModelProvider implements IApiModelProvider{
    private DataRegistry dataRegistry;

    public DeferredDeeplinkModelProvider(DataRegistry dataRegistry){
        this.dataRegistry = dataRegistry;
    }

    @Override
    public IApiModel provide() {
        String adid = dataRegistry.safeGetString(DataRegistryKey.STRING_ADID,null);

        return new DeferredDeeplinkModel(
                "and",
                adid
        );
    }
}
