package io.adbrix.sdk.data.modelprovider;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.OsPushEnableObservable;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.domain.model.CommonModel;
import io.adbrix.sdk.domain.model.DeviceModel;
import io.adbrix.sdk.domain.model.IDataModel;
import io.adbrix.sdk.domain.model.IdentityModel;
import io.adbrix.sdk.utils.CommonUtils;

public class CommonModelProvider implements IDataModelProvider {
    private DataRegistry dataRegistry;
    private Context androidContext;

    public CommonModelProvider(DataRegistry dataRegistry, Context androidContext){
        this.dataRegistry = dataRegistry;
        this.androidContext = androidContext;
    }

    @Override
    public IDataModel provide() {
        IdentityModel identityModel = new IdentityModel(
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_ADID,                null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_GAID,                null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_UUID,                null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_IDFA,                null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_IDFV,                null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_IGAW_ID,             null),
                this.dataRegistry.safeGetBoolean(   DataRegistryKey.BOOLEAN_AD_ID_OPT_OUT,      false),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_DEVICE_ID,           null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_REGISTRATION_ID,     null),
                this.dataRegistry.safeGetBoolean(   DataRegistryKey.BOOLEAN_IS_PUSH_ENABLE,     false),
                getOsPushEnable(androidContext)
        );

        DeviceModel deviceModel = new DeviceModel(
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_OS,                  null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_MODEL,               null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_VENDOR,              null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_RESOLUTION,          null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_PLATFORM,            null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_CARRIER,             null),
                this.dataRegistry.safeGetInt(       DataRegistryKey.INT_TIME_ZONE_OFFSET,       0),
                this.dataRegistry.safeGetInt(       DataRegistryKey.INT_DEVICE_TIME_TYPE,       0),
                this.dataRegistry.safeGetBoolean(   DataRegistryKey.BOOLEAN_IS_WIFI_ONLY,       false),
                this.dataRegistry.safeGetBoolean(   DataRegistryKey.BOOLEAN_IS_PORTRAIT,        false),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_NETWORK,             null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_LANGUAGE,            null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_COUNTRY,             null),
                this.dataRegistry.safeGetInt(       DataRegistryKey.INT_BATT_L,                 0),
                this.dataRegistry.safeGetBoolean(   DataRegistryKey.BOOLEAN_BATT_C,             false)
        );

        CommonModel commonModel = new CommonModel(
                CommonUtils.getCurrentUTCInDBFormat(),
                identityModel,
                deviceModel,
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_PACKAGE_NAME,        null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_APPKEY,              null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_API_VERSION,         null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_SDK_VERSION,         null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_INSTALLER,           null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_APP_VERSION,         null),
                this.dataRegistry.safeGetString(    DataRegistryKey.STRING_BUILD_ID,            null)
        );

        return commonModel;
    }



    private boolean getOsPushEnable(Context context) {
        boolean osPushEnable = true;

        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O){
                NotificationManager manager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
                NotificationChannel channel = manager.getNotificationChannel(ABXConstants.PUSH_NOTIFICATION_CHANNEL_ID);
                boolean isShowNotificationsOn = manager.areNotificationsEnabled();
                osPushEnable = isShowNotificationsOn && channel != null && channel.getImportance() != NotificationManager.IMPORTANCE_NONE;
            }
            else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N){
                NotificationManager manager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
                osPushEnable = manager.areNotificationsEnabled();
            }
            else {
                osPushEnable = true;
            }
            OsPushEnableObservable.getInstance().notifyObserver(osPushEnable);
            return osPushEnable;
        } catch (Exception e) {
            e.printStackTrace();
            AbxLog.e("ERROR :: Can't get NotificationManagerCompat... please check your project library :: Msg : " + e.getMessage(), false);
            return osPushEnable;
        }
    }
}
