package io.adbrix.sdk.data.dataprovider;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings.Secure;
import android.telephony.TelephonyManager;

import java.util.UUID;

import io.adbrix.sdk.data.SdkVersion;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;

public class DeviceStaticDataProvider extends AbstractDataProvider {
    private Context context;
    public DeviceStaticDataProvider(DataRegistry dataRegistry, Context context) {
        super(dataRegistry);
        this.context = context;
    }

    @Override
    public void provideDefaultValues() {
        putString(DataRegistryKey.STRING_IDFA,    null,            5,  true);
        putString(DataRegistryKey.STRING_IDFV,    null,            5,  true);
        putString(DataRegistryKey.STRING_DEVICE_ID,      getDeviceId(),   5,  true);
        putString(DataRegistryKey.STRING_OS,             getOS(),         5,  true);
        putString(DataRegistryKey.STRING_MODEL,          getModel(),      5,  true);
        putString(DataRegistryKey.STRING_VENDOR,         getVendor(),     5,  true);
        putString(DataRegistryKey.STRING_PLATFORM,       getPlatform(),   5,  true);
        putBoolean(DataRegistryKey.BOOLEAN_IS_WIFI_ONLY, isWifiOnly(),    5,  true);
        putString(DataRegistryKey.STRING_CARRIER,        getCarrier(),    5,  true);
        putString(DataRegistryKey.STRING_PACKAGE_NAME,   getPackageName(),5,  true);
        putString(DataRegistryKey.STRING_API_VERSION,    getAPIVersion(), 5,  true);
        putString(DataRegistryKey.STRING_SDK_VERSION,    getSDKVersion(), 5,  true);
        putString(DataRegistryKey.STRING_INSTALLER,      getInstaller(),  5,  true);
        putString(DataRegistryKey.STRING_APP_VERSION,    getAppVersion(), 5,  true);
        putString(DataRegistryKey.STRING_BUILD_ID,       getBulidId(),    5,  true);
        putUUID();
    }

    @Override
    public void asyncProvide(IDataProviderResultListener dataProviderResultListener) {
        //Context만 있으면 Default에 처리가능하기 때문에 아무처리 하지 않고 success 호출
        dataProviderResultListener.onSuccess();
    }

    @Override
    public void refreshData() {

    }

    private String getDeviceId() {
        return Secure.getString(context.getContentResolver(), Secure.ANDROID_ID);
        // Remaster에서는 이후 Event를 Post했음
    }

    private String getOS() {
        return Build.VERSION.RELEASE;
    }

    private String getModel() {
        return Build.MODEL;
    }

    private String getVendor() {
        return Build.MANUFACTURER;
    }

    private String getPlatform() {
        return "and";
    }

    private boolean isWifiOnly() {
        return context.getPackageManager().hasSystemFeature(PackageManager.FEATURE_TELEPHONY) == false;
    }

    private String getCarrier() {
        try {
            TelephonyManager manager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            return manager.getNetworkOperatorName();
        } catch (Exception e) {
            // Failed to get network operator name from network
            e.printStackTrace();
        }

        return null;
    }


    private String getPackageName() {
        return context.getPackageName();
    }

    private String getAPIVersion() {
        return SdkVersion.API_VERSION;
    }

    private String getSDKVersion() {
        return SdkVersion.SDK_VERSION;
    }

    private String getInstaller() {
        String installer = context.getPackageManager().getInstallerPackageName(getPackageName());
        if(installer != null)
        {
            return installer;
        }
        else
        {
            return "";
        }
    }

    private String getAppVersion() {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(getPackageName(), 0);
            return packageInfo.versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        return null;
    }

    private String getBulidId() {
        return Build.ID;
    }

    private void putUUID() {
        String storedUUID = safeGetString(DataRegistryKey.STRING_UUID, null);
        if(storedUUID == null)
        {
            String createdUUID = UUID.randomUUID().toString();
            putString(DataRegistryKey.STRING_UUID, createdUUID,5,true);
        }
    }
}
