package io.adbrix.sdk.data.dataprovider;

import java.util.HashSet;

public class DefaultNowaitEventNameProvider implements INoWaitEventNameProvider {

    private HashSet<String> noWaitEventNameSet;

    public DefaultNowaitEventNameProvider(){
        noWaitEventNameSet = new HashSet<String>();
        noWaitEventNameSet.add("start_session");
        noWaitEventNameSet.add("end_session");
        noWaitEventNameSet.add("daily_first_open");
        noWaitEventNameSet.add("user_property_changed");
        noWaitEventNameSet.add("login");
        noWaitEventNameSet.add("logout");
        noWaitEventNameSet.add("deeplink_open");

        noWaitEventNameSet.add("level_achieved");
        noWaitEventNameSet.add("tutorial_completed");
        noWaitEventNameSet.add("character_created");
        noWaitEventNameSet.add("stage_cleared");

        noWaitEventNameSet.add("sign_up");
        noWaitEventNameSet.add("use_credit");
        noWaitEventNameSet.add("app_update");
        noWaitEventNameSet.add("invite");
        noWaitEventNameSet.add("purchase");
        noWaitEventNameSet.add("refund");
        noWaitEventNameSet.add("add_to_cart");
        noWaitEventNameSet.add("add_to_wishlist");
        noWaitEventNameSet.add("product_view");
        noWaitEventNameSet.add("category_view");
        noWaitEventNameSet.add("review_order");
        noWaitEventNameSet.add("search");
        noWaitEventNameSet.add("share");
        noWaitEventNameSet.add("view_home");
        noWaitEventNameSet.add("list_view");
        noWaitEventNameSet.add("cart_view");
        noWaitEventNameSet.add("paymentinfo_added");

        noWaitEventNameSet.add("set_push");
        noWaitEventNameSet.add("open_push");
    }

    @Override
    public boolean isNowaitEvent(String eventName) {
        return this.noWaitEventNameSet.contains(eventName);
    }
}
