package io.adbrix.sdk.configuration;

import android.app.Activity;
import android.content.Context;

import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.domain.model.UserPropertyCommand;
import io.adbrix.sdk.domain.model.LogEventParameter;

public interface IABXContext {
    void initialize(Context context, String appkey, String secretkey);
    void saveUserProperty(UserPropertyCommand userPropertyCommand);
    void saveUserPropertyWithoutEvent(UserPropertyCommand userPropertyCommand);
    void logEvent(LogEventParameter logEventParameter);
    void runOnIdleTime();
    void onResume(Activity activity);
    void onPause();
    void deeplink(Activity deeplinkActivity);
    void putDataRegistry(DataUnit dataUnit);
    void registerNetworkCallback();
}
