package io.adbrix.sdk.configuration;

import android.app.Activity;
import android.content.Context;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.ILogger;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.domain.model.UserPropertyCommand;
import io.adbrix.sdk.domain.model.LogEventParameter;

public class DisabledABXContext implements IABXContext {

    private static final String WARNING_FOR_DISABLED_CONTEXT = "Disabled된 ABX SDK의 Method가 호출되었습니다.";
    private String disabledReason;
    private ILogger logger;

    public DisabledABXContext(IABXContextController main_controller, String disabledReason) {
        this.logger = main_controller.getComponentsFactory().createOrGetLogger();
        this.disabledReason = disabledReason;
        AbxLog.e("ABX SDK가 Disabled 되었습니다. 이유는 = "+disabledReason, true);
    }

    @Override
    public void initialize(Context context, String appkey, String secretkey) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, true);
    }

    @Override
    public void saveUserProperty(UserPropertyCommand userPropertyCommand) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, true);
    }

    @Override
    public void saveUserPropertyWithoutEvent(UserPropertyCommand userPropertyCommand) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, true);
    }

    @Override
    public void logEvent(LogEventParameter logEventParameter) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, true);
    }

    @Override
    public void runOnIdleTime() {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void onResume(Activity activity) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void onPause() {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void deeplink(Activity deeplinkActivity) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void putDataRegistry(DataUnit dataUnit) {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }

    @Override
    public void registerNetworkCallback() {
        AbxLog.w(WARNING_FOR_DISABLED_CONTEXT, false);
    }
}
