package io.adbrix.sdk.component.autoEvent;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;

import org.json.JSONException;

import java.util.HashMap;
import java.util.Map;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.DeferredDeeplinkPostingObservable;
import io.adbrix.sdk.component.GooglePlayReferrerProperties;
import io.adbrix.sdk.component.IObserver;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.modelprovider.DeferredDeeplinkModelProvider;
import io.adbrix.sdk.data.net.ApiConnection;
import io.adbrix.sdk.data.net.ApiConnectionManager;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.domain.model.IApiModel;

public class FirstOpenAutoEventGenerator{
    private Context androidContext;
    private DataRegistry dataRegistry;

    public FirstOpenAutoEventGenerator(
            DataRegistry dataRegistry,
            Context androidContext
    ){
        this.dataRegistry = dataRegistry;
        this.androidContext = androidContext;
    }

    public boolean isTrigger() {
        return dataRegistry.safeGetString(DataRegistryKey.STRING_LAST_FIRSTOPEN_ID, null) == null;
    }

//    public Map<String, Object> getFirstOpenParam() {
//        //우선순위별 검사를 한다.
//        Map<String,Object> eventProperties = null;
//
//        //1. 구글 플레이 레퍼러
//        {
//            eventProperties = this.getGooglePlayReferrerPropertiesOrNull();
//            if(eventProperties != null) {
//                return eventProperties;
//            }
//        }
//
//        //2. No 레퍼러
//        {
//            return new HashMap<>();
//        }
//    }

    public void getGooglePlayReferrerPropertiesOrNull(IObserver<Map<String, Object>> firstOpenObserver) {
        GooglePlayReferrerProperties googlePlayReferrerProperties = new GooglePlayReferrerProperties(androidContext);
        googlePlayReferrerProperties.startConnection(() -> {
            HashMap<String, Object> firstOpenParam = new HashMap<>();
            firstOpenParam.put("abx:market_install_btn_clicked", googlePlayReferrerProperties.referrerClickTime);
            firstOpenParam.put("abx:app_install_start", googlePlayReferrerProperties.appInstallTime);

            try {
                PackageInfo packageInfo = androidContext.getPackageManager().getPackageInfo(androidContext.getPackageName(), 0);
                firstOpenParam.put("abx:app_install_completed", (int) (packageInfo.firstInstallTime / 1000));
            } catch (PackageManager.NameNotFoundException e) {
                // Remaster에서는 (int) ( -1 / 1000) 을 사용했다.
                firstOpenParam.put("abx:app_install_completed", 0);
            }

            firstOpenParam.put("abx:referrer", googlePlayReferrerProperties.referrerUrl);
            firstOpenParam.put("abx:app_first_open", (int)(System.currentTimeMillis() / 1000));
            firstOpenParam.put("abx:click_adkey", googlePlayReferrerProperties.clickAdKey);

            firstOpenObserver.update(firstOpenParam);
        });
    }

    public void runDeferredDeeplinkProcess() {
        String adid;
        adid = dataRegistry.safeGetString(DataRegistryKey.STRING_ADID, null);

        AbxLog.d("getDeferredDeeplink start ::: ", true);
        if (adid != null){
            try {
                ApiConnectionManager apiConnectionManager = new ApiConnectionManager(new ApiConnectionManager.Result() {
                    @Override
                    public void connectSuccess(String responseString, int responseCode) {
                        AbxLog.d("Terminated FirstOpen", true);
                        AbxLog.i("API getDeferredDeeplink connectSuccess !! " + responseString, true);

                        DeferredDeeplinkPostingObservable.getInstance().postDeferredDeeplinkToMainThread(responseString);
                    }

                    @Override
                    public void connectFail(int responseCode) {
                        AbxLog.d("Terminated FirstOpen", true);
                        AbxLog.w("API getDeferredDeeplink connectFail !! ", true);
                        AbxLog.d("DeferredDeeplink responseCode : " + responseCode, true);
                    }
                });

                IApiModel deferredDeeplinkModel = new DeferredDeeplinkModelProvider(dataRegistry).provide();

                ApiConnection apiConnection = new ApiConnection(dataRegistry, androidContext)
                        .POST(deferredDeeplinkModel);

                apiConnectionManager.ExecuteWithRetry(apiConnection);

            } catch (JSONException e) {
                e.printStackTrace();
                AbxLog.e("Deferred Deeplink Request Error: " + e.getMessage(), true);
            }
        }
        else {
            AbxLog.w("AdvertisingId null, so cannot get DeferredDeeplink data", true);
        }

    }
}
