package io.adbrix.sdk.component.autoEvent;


import android.app.Activity;
import android.net.Uri;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.DeeplinkPostingObservable;
import io.adbrix.sdk.configuration.IABXContext;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.CoreUtils;

import java.util.Map;

public class DeeplinkAutoEventGenerator {
    private IABXContext abxContext;
    private DataRegistry dataRegistry;

    public DeeplinkAutoEventGenerator(
            IABXContext abxContext,
            DataRegistry dataRegistry
    ){
        this.abxContext = abxContext;
        this.dataRegistry = dataRegistry;
    }

    public void process(Activity deeplinkActivity) {
        if (!CoreUtils.isActivityStartedByDeeplink(deeplinkActivity, dataRegistry)){
            AbxLog.e("Check adbrix Parameters :: There is no adbrix deeplink parameter in Activity!", true);
            return;
        }

        Uri uri = CoreUtils.getDeeplinkUriFromCurrentActivity(deeplinkActivity);

        if(uri == null){
            AbxLog.d( "deeplink uri is null", true);
            return;
        }

        String deeplinkUrl = uri.toString();

        Map<String, Object> eventParam = CoreUtils.getDeeplinkParameterFromUriString(deeplinkUrl);

        LogEventParameter eventParameter = new LogEventParameter(
                CoreConstants.GROUP_ABX,
                CoreConstants.EVENT_DEEPLINK_OPEN,
                CommonUtils.parseValueWithDataType(eventParam, CommonUtils.FIX_TYPE.PREFIX),
                0,
                0);

        abxContext.putDataRegistry(
            new DataUnit(
                DataRegistryKey.STRING_LAST_DEEPLINK_ID,
                eventParameter.eventId,
                5,
                this.getClass().getName(),
                true
            ));

        abxContext.putDataRegistry(
            new DataUnit(
                DataRegistryKey.STRING_LAST_OPEN_ID,
                eventParameter.eventId,
                5,
                this.getClass().getName(),
                true
            ));

        abxContext.logEvent(eventParameter);

        DeeplinkPostingObservable.getInstance().notifyObserver(CoreUtils.getDeeplinkUriFromCurrentActivity(deeplinkActivity).toString());

        CoreUtils.clearAdbrixTrackingParamFromCurrentActivity(deeplinkActivity, dataRegistry);
    }
}