package io.adbrix.sdk.component;

import java.util.Timer;
import java.util.TimerTask;

import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.net.SocketClient;
import io.adbrix.sdk.data.net.SocketClientManager;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.utils.Base64;

public class SKDataSender {
    private Timer wifiTimer;
    private DataRegistry dataRegistry;

    private SocketClientManager clientManager = new SocketClientManager(new SocketClientManager.Result() {
        @Override
        public void connectSuccess(int responseCode) {
            //SK 공유기의 로컬 아이피에 연결이 성공했을 때
            wifiTimer = new Timer();

            String ipAndPort = dataRegistry.safeGetString(DataRegistryKey.STRING_S3_CONFIG_SK_IP_PORT, "12700000000104200");
            int pingPeriodSecond = dataRegistry.safeGetInt(DataRegistryKey.INT_S3_CONFIG_SK_PING_PERIOD_SECOND, 300_000);

            wifiTimer.schedule(new TimerTask() {
                @Override
                public void run() {

                    SocketClient client = new SocketClient(ipAndPort, getMessage());

                    client.run();

                    if (client.getResponseCode() == 200){
                        AbxLog.d( "SKB:: Sending igaw_id is complete.", true);
                    }
                    else if (client.getResponseCode() == 201) {
                        AbxLog.d( "SKB:: Sending igaw_id is skipped.", true);
                    }
                    else {
                        AbxLog.d("SKB:: Sending igaw_id is failed.", true);
                        cancelConnectToSKB();
                    }
                }
            }, pingPeriodSecond * 1000, pingPeriodSecond * 1000);
            AbxLog.d("SKB:: Connect success, ping period " + pingPeriodSecond + "s, start repeat!", true);
        }

        @Override
        public void connectFail() {
            //SK 공유기의 로컬 아이피에 연결이 실패했을 때
            AbxLog.d("SKB:: Connect fail! Cancel repeat!", true);
            if (wifiTimer != null) {
                wifiTimer.cancel();
                wifiTimer = null;
            }
        }
    });

    public SKDataSender(DataRegistry dataRegistry){
        this.dataRegistry = dataRegistry;
        wifiTimer = null;
    }

    public void wifiDisconnectAction() {
        if (wifiTimer != null) {
            wifiTimer.cancel();
            wifiTimer = null;
            AbxLog.d("SKB:: Wifi is disconnected! Cancel repeat.", true);
        }
    }

    public void wifiConnectAction() {
        AbxLog.d("SKB:: Wifi is connected!", true);

        String ipAndPort = dataRegistry.safeGetString(DataRegistryKey.STRING_S3_CONFIG_SK_IP_PORT, "12700000000104200");

        SocketClient client = new SocketClient(ipAndPort, getMessage());

        clientManager.Execute(client);
    }

    private String getMessage() {
        String igawId = dataRegistry.safeGetString(DataRegistryKey.STRING_IGAW_ID, null);
        String gaid = dataRegistry.safeGetString(DataRegistryKey.STRING_GAID, null);
        int skPingVersion = dataRegistry.safeGetInt(DataRegistryKey.INT_S3_CONFIG_SK_PING_VERSION, -1);

        switch (skPingVersion){
            case 0:
                return igawId;
            case 1:
                if (gaid != null)
                    return "0001" +  gaid  + "0036" + Base64.encode("\"os\":\"0\",\"ccode\":\"C03000\"");
                else
                    return null;
            default:
                return null;
        }
    }

    private void cancelConnectToSKB(){
        if(wifiTimer != null) {
            wifiTimer.cancel();
        }
    }
}
