package io.adbrix.sdk.component;

import android.content.Context;
import android.net.Uri;
import android.os.RemoteException;

import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;

import io.adbrix.sdk.utils.CommonUtils;

public class GooglePlayReferrerProperties {
    private Context context;
    public String referrerUrl;
    public long referrerClickTime = -1;
    public long appInstallTime = -1;
    public String clickAdKey;

    public GooglePlayReferrerProperties(Context context) {
        this.context = context;
    }

    public void startConnection(Runnable firstOpenRunnable) {
        try {
            InstallReferrerClient referrerClient = InstallReferrerClient.newBuilder(context).build();
            referrerClient.startConnection(new InstallReferrerStateListener() {
                @Override
                public void onInstallReferrerSetupFinished(int responseCode) {
                    switch (responseCode) {
                        case InstallReferrerClient.InstallReferrerResponse.OK:
                            onInstallReferrerResponseOK(referrerClient);
                            referrerClient.endConnection();
                            firstOpenRunnable.run();
                            break;
                        default:
                            // API not available on the current Play Store app. or Connection couldn't be established.
                            onInstallReferrerResponseError(responseCode);
                            referrerClient.endConnection();
                            break;
                    }
                }

                @Override
                public void onInstallReferrerServiceDisconnected() {
                    // Try to restart the connection on the next request to
                    // Google Play by calling the startConnection() method.
                    onInstallReferrerResponseError(InstallReferrerClient.InstallReferrerResponse.SERVICE_DISCONNECTED);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            //
        }
    }

    private void onInstallReferrerResponseOK(InstallReferrerClient referrerClient)
    {
        try {
            ReferrerDetails response = referrerClient.getInstallReferrer();
            if(response != null)
            {
                referrerUrl = response.getInstallReferrer();
                if(CommonUtils.isNullOrEmpty(referrerUrl) == false)
                {
                    try {
                        String abx_tid = Uri.parse("http://referrer.ad-brix.com?" + referrerUrl).getQueryParameter("abx_tid");
                        if(CommonUtils.isNullOrEmpty(abx_tid) == false)
                        {
                            clickAdKey = abx_tid;
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                long referrerClickTimestampSeconds = response.getReferrerClickTimestampSeconds();
                if(referrerClickTimestampSeconds != 0)
                {
                    referrerClickTime = referrerClickTimestampSeconds;
                }

                long installBeginTimestampSeconds = response.getInstallBeginTimestampSeconds();
                if(installBeginTimestampSeconds != 0)
                {
                    appInstallTime = installBeginTimestampSeconds;
                }
            }
            else
            {

            }
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void onInstallReferrerResponseError(int responseCode) {
        switch (responseCode){
            case -1:
                AbxLog.d("InstallReferrerResponse : SERVICE_DISCONNECTED", true);
                break;
            case 0:
                AbxLog.d("InstallReferrerResponse : OK", true);
                break;
            case 1:
                AbxLog.d("InstallReferrerResponse : SERVICE_UNAVAILABLE", true);
                break;
            case 2:
                AbxLog.d("InstallReferrerResponse : FEATURE_NOT_SUPPORTED", true);
                break;
            case 3:
                AbxLog.d("InstallReferrerResponse : DEVELOPER_ERROR", true);
                break;
            default:
                break;
        }
    }
}
