package io.adbrix.sdk.component;

import android.util.Log;

import io.adbrix.sdk.data.S3ConfigHandler;
import io.adbrix.sdk.data.dataprovider.INoWaitEventNameProvider;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.domain.model.EventModel;

import org.json.JSONArray;
import org.json.JSONException;

public class EventPackagingFacade{
    private EventBuffer eventBuffer;
    private INoWaitEventNameProvider noWaitEventNameProvider;

    public EventPackagingFacade(
            INoWaitEventNameProvider noWaitEventNameProvider,
            EventBuffer eventBuffer){
        this.eventBuffer = eventBuffer;
        EventUploadIntervalManager.getInstance().add(eventBuffer);
        this.noWaitEventNameProvider = noWaitEventNameProvider;
    }

    public void flushAllNow(){
        this.eventBuffer.flushAllNow();
    }

    public void flushAtIntervals(){
        this.eventBuffer.flushContainerAtIntervals();
    }

    public void addEventModel(EventModel eventModel)
    {
        if (isBlockedEvent(eventModel.event_name, eventModel.group)){
            return;
        }
        this.eventBuffer.addEventModel(
                eventModel,
                noWaitEventNameProvider.isNowaitEvent(
                        eventModel.event_name
                )
        );
    }

    private boolean isBlockedEvent(String eventName, String category) {
        JSONArray blockedList = S3ConfigHandler.config_blockedEventList;

        if(blockedList !=null&&blockedList.length()!=0){
            for (int i = 0; i < blockedList.length(); i++) {
                try {
                    String bannedEvent = blockedList.getString(i);
                    String[] evtSplitByCategory = bannedEvent.split(":");

                    if (evtSplitByCategory.length != 2) continue;
                    if (!evtSplitByCategory[0].equals("abx") && !evtSplitByCategory[0].equals("custom"))
                        continue;
                    if (category == CoreConstants.GROUP_CUSTOM && evtSplitByCategory[0].equals("custom")) {
                        if (evtSplitByCategory[1].equals(eventName)) {
                            AbxLog.d("EventPackagingFacade :: custom event is blocked ! : " + eventName, true);
                            return true;
                        }
                    } else if (category == CoreConstants.GROUP_ABX && evtSplitByCategory[0].equals("abx")) {
                        if (evtSplitByCategory[1].equals(eventName)) {
                            AbxLog.d("EventPackagingFacade :: ABX event is blocked ! : " + eventName, true);
                            return true;
                        }
                    }
                } catch (JSONException e) {
                    AbxLog.d("Blocked Event Exception " + e.getMessage(), true);
                    e.printStackTrace();
                }
            }
        }
        return false;
    }
}
