package io.adbrix.sdk.component;

import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.EventPackage;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class EventPackageContainer {
    private Queue<EventPackage> packageQueue;
    private HashSet<String> successPackageIdTable;
    private IEventSender eventSender;
    private DataRegistry dataRegistry;

    public EventPackageContainer(IEventSender eventSender, DataRegistry dataRegistry) {
        this.dataRegistry = dataRegistry;
        this.eventSender = eventSender;
        packageQueue = getPreviousPackageQueue();
        AbxLog.d( "getPreviousPackageQueue : " + packageQueue.size(), true);
        successPackageIdTable = new HashSet<>();
    }

    public void updateUnsentEventPackagesInDataRegistry(){

        JSONArray jsonArray = new JSONArray();

        for (EventPackage eventPackage : packageQueue){
            try {
                jsonArray.put(eventPackage.toJson());
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        dataRegistry.putDataRegistry(new DataUnit(
                DataRegistryKey.STRING_UNSENT_EVENTPACKAGES,
                jsonArray.toString(),
                5,
                this.getClass().getName(),
                true
        ));
    }

    private Queue<EventPackage> getPreviousPackageQueue(){
        String unsentEventPackagesString = dataRegistry
                .safeGetString(DataRegistryKey.STRING_UNSENT_EVENTPACKAGES, null);

        if (unsentEventPackagesString == null) return new ConcurrentLinkedQueue<>();

        JSONArray jsonArray = null;
        try {
            jsonArray = new JSONArray(unsentEventPackagesString);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (jsonArray == null) return new ConcurrentLinkedQueue<>();

        Queue<EventPackage> tempQueue = new ConcurrentLinkedQueue<>();
        try {
            for (int i = 0; i < jsonArray.length(); i++) {
                EventPackage eventPackage = EventPackage.fromJson(jsonArray.getJSONObject(i));

                if (eventPackage == null) break;

                tempQueue.offer(eventPackage);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }


        if (tempQueue.isEmpty()) return new ConcurrentLinkedQueue<>();
        else return tempQueue;
    }

    public void addEventPackage(EventPackage sendWaitEventPackage) {
        if(!successPackageIdTable.contains(sendWaitEventPackage.packageId)) {
            this.packageQueue.offer(sendWaitEventPackage);
        }
    }

    public void flushAtIntervals() {

        Runnable eventSendingTask = new Runnable() {
            @Override
            public void run() {
                flushEventsNotSent();
            }
        };

        EventUploadIntervalManager.getInstance().manageEventUploadInterval(eventSendingTask, packageQueue);
    }

    public void flushSingleEventPackageImmediately(EventPackage eventPackage){

        eventSender.EventSend(eventPackage, new IEventSender.IEventSendActionListener() {
            @Override
            public void onSuccess(EventPackage successfulEventPackage) {
                successPackageIdTable.add(successfulEventPackage.packageId);
            }

            @Override
            public void onFail(EventPackage failedEventPackage) {
                EventPackageContainer.this.addEventPackage(failedEventPackage);
            }

            @Override
            public void onComplete() {

            }
        });
    }

    public void flushEventsNotSent(){
        //fail된 eventPackage는 다음에 보내기 위한 장치
        int currentQueueSize = packageQueue.size();

        for (int i = 0; i < currentQueueSize; i++){
            final EventPackage eventPackage = packageQueue.poll();

            flushSingleEventPackageImmediately(eventPackage);
        }
    }
}
