package io.adbrix.sdk.component;

import android.content.Context;

import org.json.JSONException;

import io.adbrix.sdk.data.ABXBooleanState;
import io.adbrix.sdk.data.modelprovider.CommonModelProvider;
import io.adbrix.sdk.data.modelprovider.EventBundleModelProvider;
import io.adbrix.sdk.data.net.ApiConnection;
import io.adbrix.sdk.data.net.ApiConnectionManager;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.EventPackage;
import io.adbrix.sdk.domain.model.IApiModel;
import io.adbrix.sdk.domain.model.IDataModel;
import io.adbrix.sdk.utils.CoreUtils;

public class DefaultEventSender implements IEventSender {
    private DataRegistry dataRegistry;
    private Context androidContext;

    public DefaultEventSender(DataRegistry dataRegistry, Context androidContext) {
        this.dataRegistry = dataRegistry;
        this.androidContext = androidContext;
    }

    @Override
    public void EventSend(EventPackage eventPackage, IEventSendActionListener sendActionListener) {
        if (eventPackage == null || eventPackage.eventModels == null) {
            AbxLog.d("Invalid eventPackage!", true);
            return;
        }

        if (!CoreUtils.isOnline(androidContext)){
            AbxLog.e("Fail to sending event. You are not connected to the network.", true);
            sendActionListener.onFail(eventPackage);
            return;
        }

        if (ABXBooleanState.getInstance().isGdprForgetMe()){
            AbxLog.d("GdprForgetMe is true", true);
            sendActionListener.onFail(eventPackage);
            return;
        }

        IDataModel commonModel = new CommonModelProvider(dataRegistry, androidContext).provide();
        IApiModel eventBundleModel = (IApiModel) new EventBundleModelProvider(commonModel, eventPackage).provide();

        ApiConnection apiConnection;
        ApiConnectionManager manager = new ApiConnectionManager(new ApiConnectionManager.Result() {
            @Override
            public void connectSuccess(String responseString, int responseCode) {
                sendActionListener.onSuccess(eventPackage);
                AbxLog.d( "Sending event is complete. responseCode : " + responseCode + ", responseString : " + responseString, true);
            }

            @Override
            public void connectFail(int responseCode) {
                sendActionListener.onFail(eventPackage);
                AbxLog.d("Sending event is failed. responseCode : " + responseCode, true);
            }
        });

        try {
            AbxLog.d(eventBundleModel.getJson().toString(4), true);
            apiConnection = new ApiConnection(dataRegistry, androidContext).POST(eventBundleModel);
            manager.Execute(apiConnection);

        } catch (JSONException e) {
            AbxLog.e( "updateServer >> JSONException: " + e.toString(), true);
            e.printStackTrace();
        }
    }
}