package io.adbrix.sdk.component;

import android.content.Context;

import io.adbrix.sdk.component.autoEvent.DeeplinkAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.FirstOpenAutoEventGenerator;
import io.adbrix.sdk.component.autoEvent.SessionAutoEventGenerator;
import io.adbrix.sdk.configuration.IABXContext;
import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.dataprovider.DeviceStaticDataProvider;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.data.repository.UserPropertyManager;
import io.adbrix.sdk.data.repository.datasource.DefaultDataContext;
import io.adbrix.sdk.data.repository.datasource.IDataContext;

public class DefaultComponentsFactory implements IABXComponentsFactory {
    private ILogger logger;
    private IDataContext dataContext;
    private DataRegistry dataRegistry;
    private Context androidContext;
    private IABXContext abxContext;
    private DeviceRealtimeDataProvider deviceRealtimeDataProvider;
    private DeviceStaticDataProvider deviceStaticDataProvider;
    private UserPropertyManager userPropertyManager;
    private IEventSender eventSender;
    private FirstOpenAutoEventGenerator firstOpenAutoEventGenerator;
    private DeeplinkAutoEventGenerator deeplinkAutoEventGenerator;
    private SessionAutoEventGenerator sessionAutoEventGenerator;

    @Override
    public void setAndroidContext(Context context) {
        this.androidContext = context;
    }

    @Override
    public void setABXContext(IABXContext context) { this.abxContext = context; }

    @Override
    public Context getAndroidContext() throws ComponentsCanNotCreateException {
        if(this.androidContext == null)
        {
            throw new ComponentsCanNotCreateException("안드로이드 컨텍스트를 먼저 입력해야 합니다.");
        }

        return this.androidContext;
    }

    @Override
    public UserPropertyManager createOrGetUserPropertyManager() throws ComponentsCanNotCreateException {
        if(this.userPropertyManager == null)
        {
            this.userPropertyManager = new UserPropertyManager(
                    this.createOrGetDataContext(),
                    this.createOrGetLogger(),
                    this.createOrGetDataRegistry()
            );
        }

        return this.userPropertyManager;
    }

    @Override
    public IEventSender createOrGetEventSender() throws ComponentsCanNotCreateException {
        if(this.eventSender == null)
        {
            this.eventSender = new DefaultEventSender(
                    this.createOrGetDataRegistry(),
                    this.getAndroidContext()
            );
        }

        return this.eventSender;
    }

    @Override
    public IABXContext getABXContext() throws ComponentsCanNotCreateException {
        if(this.abxContext == null)
        {
            throw new ComponentsCanNotCreateException("ABXContext를 먼저 입력해야 합니다.");
        }

        return this.abxContext;
    }

    @Override
    public FirstOpenAutoEventGenerator createOrGetFirstOpenAutoEventGenerator() throws ComponentsCanNotCreateException {
        if(this.firstOpenAutoEventGenerator == null)
        {
            this.firstOpenAutoEventGenerator = new FirstOpenAutoEventGenerator(
                    this.createOrGetDataRegistry(),
                    this.getAndroidContext()
            );
        }

        return this.firstOpenAutoEventGenerator;
    }

    @Override
    public DeeplinkAutoEventGenerator createOrGetDeeplinkAutoEventGenerator() throws ComponentsCanNotCreateException {
        if(this.deeplinkAutoEventGenerator == null)
        {
            this.deeplinkAutoEventGenerator = new DeeplinkAutoEventGenerator(
                    this.getABXContext(),
                    this.createOrGetDataRegistry()
            );
        }

        return this.deeplinkAutoEventGenerator;
    }

    @Override
    public SessionAutoEventGenerator createOrGetSessionAutoEventGenerator() throws ComponentsCanNotCreateException {
        if(this.sessionAutoEventGenerator == null)
        {
            this.sessionAutoEventGenerator = new SessionAutoEventGenerator(
                    this.getABXContext(),
                    this.createOrGetDataRegistry(),
                    this.createOrGetFirstOpenAutoEventGenerator()
            );
        }

        return this.sessionAutoEventGenerator;
    }


    @Override
    public ILogger createOrGetLogger() {
        if(this.logger == null)
        {
            this.logger = new DefaultLogger();
        }

        return this.logger;
    }

    @Override
    public DataRegistry createOrGetDataRegistry() throws ComponentsCanNotCreateException {

        if(this.dataRegistry == null)
        {
            this.dataRegistry = new DataRegistry(
                    this.createOrGetDataContext(),
                    this.createOrGetLogger()
            );
        }

        return this.dataRegistry;
    }

    @Override
    public IDataContext createOrGetDataContext() throws ComponentsCanNotCreateException {

        if(this.dataContext == null)
        {
            this.dataContext = new DefaultDataContext(
                    this.getAndroidContext()
            );
        }

        return this.dataContext;
    }

    @Override
    public DeviceRealtimeDataProvider createOrGetDeviceRealtimeDataProvider() throws ComponentsCanNotCreateException {
        if(this.deviceRealtimeDataProvider == null)
        {
            this.deviceRealtimeDataProvider = new DeviceRealtimeDataProvider(
                    this.createOrGetDataRegistry(),
                    this.getAndroidContext()
            );
        }

        return this.deviceRealtimeDataProvider;
    }

    @Override
    public DeviceStaticDataProvider createOrGetDeviceStaticDataProvider() throws ComponentsCanNotCreateException {
        if(this.deviceStaticDataProvider == null)
        {
            this.deviceStaticDataProvider = new DeviceStaticDataProvider(
                    this.createOrGetDataRegistry(),
                    this.getAndroidContext()
            );
        }

        return this.deviceStaticDataProvider;
    }
}
